/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import javax.servlet.http.WebConnection;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.server.TimeoutHandler;
import org.glassfish.grizzly.http.server.util.Enumerator;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.servlet.AsyncContextImpl;
import org.glassfish.grizzly.servlet.CookieWrapper;
import org.glassfish.grizzly.servlet.Holders;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.glassfish.grizzly.servlet.HttpSessionImpl;
import org.glassfish.grizzly.servlet.ServletInputStreamImpl;
import org.glassfish.grizzly.servlet.ServletReaderImpl;
import org.glassfish.grizzly.servlet.WebConnectionImpl;
import org.glassfish.grizzly.servlet.WebappContext;

public class HttpServletRequestImpl
implements HttpServletRequest,
Holders.RequestHolder {
    private static final Logger LOGGER = Grizzly.logger(HttpServletRequestImpl.class);
    protected Request request = null;
    protected HttpServletResponseImpl servletResponse;
    private boolean isAsyncSupported = true;
    private final AtomicBoolean asyncStarted = new AtomicBoolean();
    private AsyncContextImpl asyncContext;
    private boolean isAsyncComplete;
    private Thread asyncStartedThread;
    private final ServletInputStreamImpl inputStream = new ServletInputStreamImpl(this);
    private ServletReaderImpl reader;
    private HttpSessionImpl httpSession = null;
    private WebappContext contextImpl;
    private String contextPath = "";
    private String servletPath = "";
    private String pathInfo;
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    private boolean upgrade = false;
    private HttpUpgradeHandler httpUpgradeHandler;
    private static final ThreadCache.CachedTypeIndex<HttpServletRequestImpl> CACHE_IDX = ThreadCache.obtainIndex(HttpServletRequestImpl.class, (int)2);

    public static HttpServletRequestImpl create() {
        HttpServletRequestImpl request = (HttpServletRequestImpl)ThreadCache.takeFromCache(CACHE_IDX);
        if (request != null) {
            return request;
        }
        return new HttpServletRequestImpl();
    }

    protected HttpServletRequestImpl() {
    }

    public void initialize(Request request, HttpServletResponseImpl servletResponse, WebappContext context) throws IOException {
        this.request = request;
        this.servletResponse = servletResponse;
        this.inputStream.initialize();
        this.contextImpl = context;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Object getAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetAttributePrivilegedAction());
        }
        return new Enumerator((Collection)this.request.getAttributeNames());
    }

    public String getCharacterEncoding() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetCharacterEncodingPrivilegedAction());
        }
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        this.request.setCharacterEncoding(env);
    }

    public int getContentLength() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getContentLength();
    }

    public long getContentLengthLong() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getContentLengthLong();
    }

    public String getContentType() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException("Illegal attempt to call getInputStream() after getReader() has already been called.");
        }
        this.usingInputStream = true;
        return this.inputStream;
    }

    void recycle() {
        this.request = null;
        this.servletResponse = null;
        this.reader = null;
        this.inputStream.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.upgrade = false;
        this.httpUpgradeHandler = null;
        if (this.asyncContext != null) {
            this.asyncContext.clear();
            this.asyncContext = null;
        }
        this.isAsyncSupported = true;
        this.asyncStarted.set(false);
        this.isAsyncComplete = false;
        this.asyncStartedThread = null;
    }

    public String getParameter(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetParameterPrivilegedAction(name));
        }
        return this.request.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return new Enumerator((Collection)AccessController.doPrivileged(new GetParameterNamesPrivilegedAction()));
        }
        return new Enumerator((Collection)this.request.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        String[] ret;
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            ret = AccessController.doPrivileged(new GetParameterValuePrivilegedAction(name));
            if (ret != null) {
                ret = (String[])ret.clone();
            }
        } else {
            ret = this.request.getParameterValues(name);
        }
        return ret;
    }

    public Map<String, String[]> getParameterMap() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetParameterMapPrivilegedAction());
        }
        return this.request.getParameterMap();
    }

    public String getProtocol() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getProtocol().getProtocolString();
    }

    public String getScheme() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getScheme();
    }

    public String getServerName() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getServerName();
    }

    public int getServerPort() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException("Illegal attempt to call getReader() after getInputStream() has already been called.");
        }
        this.usingReader = true;
        if (this.reader == null) {
            this.reader = new ServletReaderImpl(this.request.getReader());
        }
        return this.reader;
    }

    public String getRemoteAddr() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRemoteHost();
    }

    public void setAttribute(String name, Object value) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        Object oldValue = this.request.getAttribute(name);
        this.request.setAttribute(name, value);
        EventListener[] listeners = this.contextImpl.getEventListeners();
        if (listeners.length == 0) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        int len = listeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(listeners[i] instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners[i];
            try {
                if (event == null) {
                    event = oldValue != null ? new ServletRequestAttributeEvent((ServletContext)this.contextImpl, (ServletRequest)this, name, oldValue) : new ServletRequestAttributeEvent((ServletContext)this.contextImpl, (ServletRequest)this, name, value);
                }
                if (oldValue != null) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_ADD_ERROR((Object)"ServletRequestAttributeListener", (Object)listener.getClass().getName()), t);
            }
        }
    }

    public void removeAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        Object value = this.request.getAttribute(name);
        this.request.removeAttribute(name);
        EventListener[] listeners = this.contextImpl.getEventListeners();
        if (listeners.length == 0) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        int len = listeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(listeners[i] instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners[i];
            try {
                if (event == null) {
                    event = new ServletRequestAttributeEvent((ServletContext)this.contextImpl, (ServletRequest)this, name, value);
                }
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_REMOVE_ERROR((Object)"ServletRequestAttributeListener", (Object)listener.getClass().getName()), t);
            }
        }
    }

    public Locale getLocale() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetLocalePrivilegedAction());
        }
        return this.request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetLocalesPrivilegedAction());
        }
        return new Enumerator((Collection)this.request.getLocales());
    }

    public boolean isSecure() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetRequestDispatcherPrivilegedAction(path));
        }
        return this.getRequestDispatcherInternal(path);
    }

    private RequestDispatcher getRequestDispatcherInternal(String path) {
        String pathInfo;
        if (this.contextImpl == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.contextImpl.getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String requestPath = (pathInfo = this.getPathInfo()) == null ? servletPath : servletPath + pathInfo;
        int pos = requestPath.lastIndexOf(47);
        String relative = pos >= 0 ? requestPath.substring(0, pos + 1) + path : requestPath + path;
        return this.contextImpl.getRequestDispatcher(relative);
    }

    public String getRealPath(String path) {
        return this.contextImpl.getRealPath(path);
    }

    public String getAuthType() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getAuthType();
    }

    public org.glassfish.grizzly.http.Cookie[] getGrizzlyCookies() {
        org.glassfish.grizzly.http.Cookie[] ret;
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            ret = AccessController.doPrivileged(new GetCookiesPrivilegedAction());
            if (ret != null) {
                ret = (org.glassfish.grizzly.http.Cookie[])ret.clone();
            }
        } else {
            ret = this.request.getCookies();
        }
        return ret;
    }

    public long getDateHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetHeadersPrivilegedAction(name));
        }
        return new Enumerator(this.request.getHeaders(name).iterator());
    }

    public Enumeration<String> getHeaderNames() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetHeaderNamesPrivilegedAction());
        }
        return new Enumerator(this.request.getHeaderNames().iterator());
    }

    public int getIntHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getIntHeader(name);
    }

    public String getMethod() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getMethod().getMethodString();
    }

    public String getPathInfo() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.pathInfo;
    }

    public String getPathTranslated() {
        if (this.getPathInfo() == null) {
            return null;
        }
        return this.contextImpl.getRealPath(this.getPathInfo());
    }

    public String getContextPath() {
        return this.contextPath;
    }

    protected void setContextPath(String contextPath) {
        this.contextPath = contextPath == null ? "" : contextPath;
    }

    public String getQueryString() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        throw new IllegalStateException("Not yet implemented");
    }

    public Principal getUserPrincipal() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return Request.appendRequestURL((Request)this.request, (StringBuffer)new StringBuffer());
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        if (this.httpSession != null && this.httpSession.isValid()) {
            return this.httpSession;
        }
        this.httpSession = null;
        Session internalSession = this.request.getSession(create);
        if (internalSession == null) {
            return null;
        }
        this.httpSession = new HttpSessionImpl(this.contextImpl, internalSession);
        if (this.httpSession.isNew()) {
            this.httpSession.notifyNew();
        }
        return this.httpSession;
    }

    public HttpSession getSession() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.getSession(true);
    }

    public String changeSessionId() {
        String oldSessionId = this.request.changeSessionId();
        this.getSession(false);
        this.httpSession.notifyIdChanged(oldSessionId);
        return oldSessionId;
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public Cookie[] getCookies() {
        org.glassfish.grizzly.http.Cookie[] internalCookies = this.request.getCookies();
        if (internalCookies == null) {
            return null;
        }
        int cookieIdx = 0;
        Cookie[] cookies = new Cookie[internalCookies.length];
        for (org.glassfish.grizzly.http.Cookie cookie : internalCookies) {
            if (cookie instanceof CookieWrapper) {
                cookies[cookieIdx++] = ((CookieWrapper)cookie).getWrappedCookie();
                continue;
            }
            try {
                Cookie currentCookie = new Cookie(cookie.getName(), cookie.getValue());
                currentCookie.setComment(cookie.getComment());
                if (cookie.getDomain() != null) {
                    currentCookie.setDomain(cookie.getDomain());
                }
                currentCookie.setMaxAge(cookie.getMaxAge());
                currentCookie.setPath(cookie.getPath());
                currentCookie.setSecure(cookie.isSecure());
                currentCookie.setVersion(cookie.getVersion());
                cookies[cookieIdx++] = currentCookie;
            }
            catch (IllegalArgumentException iae) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_COOKIE_CREATE_ERROR((Object)cookie.getName(), (Object)iae.getLocalizedMessage()));
            }
        }
        return cookieIdx == cookies.length ? cookies : Arrays.copyOf(cookies, cookieIdx);
    }

    public int getRemotePort() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRemotePort();
    }

    public String getLocalName() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getLocalAddr();
    }

    public int getLocalPort() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getLocalPort();
    }

    protected WebappContext getContextImpl() {
        return this.contextImpl;
    }

    protected void setContextImpl(WebappContext contextImpl) {
        this.contextImpl = contextImpl;
    }

    public void setServletPath(String servletPath) {
        if (servletPath != null) {
            this.servletPath = servletPath.length() == 0 ? "" : servletPath;
        }
    }

    protected void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public Request getRequest() {
        return this.request;
    }

    public ServletContext getServletContext() {
        return this.contextImpl;
    }

    @Override
    public Request getInternalRequest() {
        return this.request;
    }

    public DispatcherType getDispatcherType() {
        DispatcherType dispatcher = (DispatcherType)this.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
        if (dispatcher == null) {
            dispatcher = DispatcherType.REQUEST;
        }
        return dispatcher;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.startAsync((ServletRequest)this, (ServletResponse)this.servletResponse);
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return this.startAsync(servletRequest, servletResponse, false);
    }

    private AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) throws IllegalStateException {
        if (servletRequest == null || servletResponse == null) {
            throw new IllegalArgumentException("Null request or response");
        }
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("Request is within the scope of a filter or servlet that does not support asynchronous operations");
        }
        AsyncContextImpl asyncContextLocal = this.asyncContext;
        if (asyncContextLocal != null) {
            if (this.isAsyncStarted()) {
                throw new IllegalStateException("ServletRequest.startAsync called again without any asynchronous dispatch, or called outside the scope of any such dispatch, or called again within the scope of the same dispatch");
            }
            if (this.isAsyncComplete) {
                throw new IllegalStateException("Response already closed");
            }
            if (!asyncContextLocal.isStartAsyncInScope()) {
                throw new IllegalStateException("ServletRequest.startAsync called outside the scope of an async dispatch");
            }
            asyncContextLocal.reinitialize(servletRequest, servletResponse, isStartAsyncWithZeroArg);
        } else {
            AsyncContextImpl asyncContextFinal;
            this.asyncContext = asyncContextFinal = new AsyncContextImpl(this, servletRequest, servletResponse, isStartAsyncWithZeroArg);
            EmptyCompletionHandler<Response> requestCompletionHandler = new EmptyCompletionHandler<Response>(){

                public void completed(Response response) {
                    asyncContextFinal.notifyAsyncListeners(AsyncContextImpl.AsyncEventType.COMPLETE, null);
                }
            };
            TimeoutHandler timeoutHandler = new TimeoutHandler(){

                public boolean onTimeout(Response response) {
                    return HttpServletRequestImpl.this.processTimeout();
                }
            };
            this.request.getResponse().suspend(-1L, TimeUnit.MILLISECONDS, (CompletionHandler)requestCompletionHandler, timeoutHandler);
            this.asyncStartedThread = Thread.currentThread();
        }
        this.asyncStarted.set(true);
        return this.asyncContext;
    }

    public boolean isAsyncStarted() {
        return this.asyncStarted.get();
    }

    void setAsyncStarted(boolean asyncStarted) {
        this.asyncStarted.set(asyncStarted);
    }

    public void disableAsyncSupport() {
        this.isAsyncSupported = false;
    }

    void setAsyncTimeout(long timeout) {
        this.request.getResponse().getSuspendContext().setTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    public boolean isAsyncSupported() {
        return this.isAsyncSupported;
    }

    public AsyncContext getAsyncContext() {
        if (!this.isAsyncStarted()) {
            throw new IllegalStateException("The request has not been put into asynchronous mode, must call ServletRequest.startAsync first");
        }
        return this.asyncContext;
    }

    void asyncComplete() {
        if (this.isAsyncComplete) {
            throw new IllegalStateException("Request already released from asynchronous mode");
        }
        this.isAsyncComplete = true;
        this.asyncStarted.set(false);
        if (this.asyncStartedThread != Thread.currentThread() || !this.asyncContext.isOkToConfigure()) {
            this.request.getResponse().resume();
        } else {
            Response.SuspendedContextImpl suspendContext = (Response.SuspendedContextImpl)this.request.getResponse().getSuspendContext();
            suspendContext.markResumed();
            suspendContext.getSuspendStatus().reset();
        }
    }

    void asyncTimeout() {
        if (this.asyncContext != null) {
            this.asyncContext.notifyAsyncListeners(AsyncContextImpl.AsyncEventType.TIMEOUT, null);
        }
        this.errorDispatchAndComplete(null);
    }

    void onAfterService() throws IOException {
        if (this.asyncContext != null) {
            this.asyncContext.setOkToConfigure(false);
            if (this.asyncStarted.get()) {
                this.request.getResponse().getSuspendContext().setTimeout(this.asyncContext.getTimeout(), TimeUnit.MILLISECONDS);
            }
        } else if (this.isUpgrade()) {
            if (this.httpUpgradeHandler != null) {
                WebConnection wc = WebConnectionFactory.create(this, this.getInputStream(), this.servletResponse.getOutputStream());
                this.httpUpgradeHandler.init(wc);
            } else {
                LOGGER.log(Level.SEVERE, "HttpUpgradeHandler handler cannot be null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processTimeout() {
        boolean result2;
        AsyncContextImpl asyncContextLocal = this.asyncContext;
        try {
            this.asyncTimeout();
            result2 = asyncContextLocal != null && !asyncContextLocal.getAndResetDispatchInScope();
        }
        catch (Throwable throwable) {
            boolean result2 = asyncContextLocal != null && !asyncContextLocal.getAndResetDispatchInScope();
            throw throwable;
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void errorDispatchAndComplete(Throwable t) {
        block2: {
            if (this.asyncContext == null || this.asyncContext.isDispatchInScope() || this.isAsyncComplete || !this.isAsyncStarted()) break block2;
            this.servletResponse.setStatus(500);
            if (t != null) {
                this.setAttribute("javax.servlet.error.exception", t);
            }
            if (!this.isAsyncComplete && this.isAsyncStarted()) {
                this.asyncComplete();
            }
        }
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException {
        T handler;
        this.upgrade = true;
        try {
            handler = this.contextImpl.createHttpUpgradeHandlerInstance(handlerClass);
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
        this.httpUpgradeHandler = handler;
        this.request.getResponse().suspend();
        return handler;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public HttpUpgradeHandler getHttpUpgradeHandler() {
        return this.httpUpgradeHandler;
    }

    public boolean authenticate(HttpServletResponse hsr) throws IOException, ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void login(String string, String string1) throws ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Part getPart(String string) throws IOException, ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static class WebConnectionFactory {
        WebConnectionFactory() {
        }

        static WebConnection create(HttpServletRequestImpl req, ServletInputStream inputStream, ServletOutputStream outputStream) {
            return new WebConnectionImpl(req, inputStream, outputStream);
        }
    }

    private final class GetLocalesPrivilegedAction
    implements PrivilegedAction<Enumeration<Locale>> {
        private GetLocalesPrivilegedAction() {
        }

        @Override
        public Enumeration<Locale> run() {
            return new Enumerator((Collection)HttpServletRequestImpl.this.request.getLocales());
        }
    }

    private final class GetLocalePrivilegedAction
    implements PrivilegedAction<Locale> {
        private GetLocalePrivilegedAction() {
        }

        @Override
        public Locale run() {
            return HttpServletRequestImpl.this.request.getLocale();
        }
    }

    private final class GetHeaderNamesPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetHeaderNamesPrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return new Enumerator(HttpServletRequestImpl.this.request.getHeaderNames());
        }
    }

    private final class GetHeadersPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private final String name;

        public GetHeadersPrivilegedAction(String name) {
            this.name = name;
        }

        @Override
        public Enumeration<String> run() {
            return new Enumerator(HttpServletRequestImpl.this.request.getHeaders(this.name));
        }
    }

    private final class GetCharacterEncodingPrivilegedAction
    implements PrivilegedAction<String> {
        private GetCharacterEncodingPrivilegedAction() {
        }

        @Override
        public String run() {
            return HttpServletRequestImpl.this.request.getCharacterEncoding();
        }
    }

    private final class GetCookiesPrivilegedAction
    implements PrivilegedAction<org.glassfish.grizzly.http.Cookie[]> {
        private GetCookiesPrivilegedAction() {
        }

        @Override
        public org.glassfish.grizzly.http.Cookie[] run() {
            return HttpServletRequestImpl.this.request.getCookies();
        }
    }

    private final class GetParameterValuePrivilegedAction
    implements PrivilegedAction<String[]> {
        public final String name;

        public GetParameterValuePrivilegedAction(String name) {
            this.name = name;
        }

        @Override
        public String[] run() {
            return HttpServletRequestImpl.this.request.getParameterValues(this.name);
        }
    }

    private final class GetParameterNamesPrivilegedAction
    implements PrivilegedAction<Set<String>> {
        private GetParameterNamesPrivilegedAction() {
        }

        @Override
        public Set<String> run() {
            return HttpServletRequestImpl.this.request.getParameterNames();
        }
    }

    private final class GetParameterPrivilegedAction
    implements PrivilegedAction<String> {
        public final String name;

        public GetParameterPrivilegedAction(String name) {
            this.name = name;
        }

        @Override
        public String run() {
            return HttpServletRequestImpl.this.request.getParameter(this.name);
        }
    }

    private final class GetRequestDispatcherPrivilegedAction
    implements PrivilegedAction<RequestDispatcher> {
        private final String path;

        public GetRequestDispatcherPrivilegedAction(String path) {
            this.path = path;
        }

        @Override
        public RequestDispatcher run() {
            return HttpServletRequestImpl.this.getRequestDispatcherInternal(this.path);
        }
    }

    private final class GetParameterMapPrivilegedAction
    implements PrivilegedAction<Map<String, String[]>> {
        private GetParameterMapPrivilegedAction() {
        }

        @Override
        public Map<String, String[]> run() {
            return HttpServletRequestImpl.this.request.getParameterMap();
        }
    }

    private final class GetAttributePrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetAttributePrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return new Enumerator((Collection)HttpServletRequestImpl.this.request.getAttributeNames());
        }
    }
}

