/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.oauth1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.uri.UriComponent;

class RequestUtil {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];

    RequestUtil() {
    }

    public static MultivaluedMap<String, String> getQueryParameters(ClientRequestContext request) {
        URI uri = request.getUri();
        if (uri == null) {
            return null;
        }
        return UriComponent.decodeQuery((URI)uri, (boolean)true);
    }

    public static MultivaluedMap<String, String> getEntityParameters(ClientRequestContext request, MessageBodyWorkers messageBodyWorkers) {
        Object entity = request.getEntity();
        String method = request.getMethod();
        MediaType mediaType = request.getMediaType();
        if (entity == null || method == null || !method.equalsIgnoreCase("POST") || mediaType == null || !mediaType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
            return new MultivaluedHashMap();
        }
        if (entity instanceof MultivaluedMap) {
            return (MultivaluedMap)entity;
        }
        Type entityType = entity.getClass();
        if (entity instanceof GenericEntity) {
            GenericEntity generic = (GenericEntity)entity;
            entityType = generic.getType();
            entity = generic.getEntity();
        }
        Class<?> entityClass = entity.getClass();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageBodyWriter writer = messageBodyWorkers.getMessageBodyWriter(entityClass, entityType, EMPTY_ANNOTATIONS, MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        try {
            writer.writeTo(entity, entityClass, entityType, EMPTY_ANNOTATIONS, MediaType.APPLICATION_FORM_URLENCODED_TYPE, null, (OutputStream)out);
        }
        catch (WebApplicationException wae) {
            throw new IllegalStateException(wae);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        MessageBodyReader reader = messageBodyWorkers.getMessageBodyReader(MultivaluedMap.class, MultivaluedMap.class, EMPTY_ANNOTATIONS, MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        try {
            return (MultivaluedMap)reader.readFrom(MultivaluedMap.class, MultivaluedMap.class, EMPTY_ANNOTATIONS, MediaType.APPLICATION_FORM_URLENCODED_TYPE, null, (InputStream)in);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

