// CheckStyle: start generated
package com.oracle.truffle.js.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;

@GeneratedBy(JSTypes.class)
public final class JSTypesGen extends JSTypes {

    protected JSTypesGen() {
    }

    public static boolean isBoolean(Object value) {
        return value instanceof Boolean;
    }

    public static boolean asBoolean(Object value) {
        assert value instanceof Boolean : "JSTypesGen.asBoolean: boolean expected";
        return (boolean) value;
    }

    public static boolean expectBoolean(Object value) throws UnexpectedResultException {
        if (value instanceof Boolean) {
            return (boolean) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isInteger(Object value) {
        return value instanceof Integer;
    }

    public static int asInteger(Object value) {
        assert value instanceof Integer : "JSTypesGen.asInteger: int expected";
        return (int) value;
    }

    public static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (int) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isDouble(Object value) {
        return value instanceof Double;
    }

    public static double asDouble(Object value) {
        assert value instanceof Double : "JSTypesGen.asDouble: double expected";
        return (double) value;
    }

    public static double expectDouble(Object value) throws UnexpectedResultException {
        if (value instanceof Double) {
            return (double) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isLong(Object value) {
        return value instanceof Long;
    }

    public static long asLong(Object value) {
        assert value instanceof Long : "JSTypesGen.asLong: long expected";
        return (long) value;
    }

    public static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (long) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isSafeInteger(Object value) {
        return value instanceof SafeInteger;
    }

    public static SafeInteger asSafeInteger(Object value) {
        assert value instanceof SafeInteger : "JSTypesGen.asSafeInteger: SafeInteger expected";
        return (SafeInteger) value;
    }

    public static SafeInteger expectSafeInteger(Object value) throws UnexpectedResultException {
        if (value instanceof SafeInteger) {
            return (SafeInteger) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isBigInt(Object value) {
        return value instanceof BigInt;
    }

    public static BigInt asBigInt(Object value) {
        assert value instanceof BigInt : "JSTypesGen.asBigInt: BigInt expected";
        return (BigInt) value;
    }

    public static BigInt expectBigInt(Object value) throws UnexpectedResultException {
        if (value instanceof BigInt) {
            return (BigInt) value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static double expectImplicitDouble(int state, Object value) throws UnexpectedResultException {
        if ((state & 0b1) != 0 && value instanceof Double) {
            return (double) value;
        } else if ((state & 0b10) != 0 && value instanceof Integer) {
            return intToDouble((int) value);
        } else if ((state & 0b100) != 0 && value instanceof SafeInteger) {
            return safeIntegerToDouble((SafeInteger) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(value);
        }
    }

    public static boolean isImplicitDouble(int state, Object value) {
        return ((state & 0b1) != 0 && value instanceof Double)
             || ((state & 0b10) != 0 && value instanceof Integer)
             || ((state & 0b100) != 0 && value instanceof SafeInteger);
    }

    public static boolean isImplicitDouble(Object value) {
        return value instanceof Double
             || value instanceof Integer
             || value instanceof SafeInteger;
    }

    public static double asImplicitDouble(int state, Object value) {
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            return asImplicitDouble(value);
        }
        if ((state & 0b1) != 0 && value instanceof Double) {
            return (double) value;
        } else if ((state & 0b10) != 0 && value instanceof Integer) {
            return intToDouble((int) value);
        } else if ((state & 0b100) != 0 && value instanceof SafeInteger) {
            return safeIntegerToDouble((SafeInteger) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static double asImplicitDouble(Object value) {
        if (value instanceof Double) {
            return (double) value;
        } else if (value instanceof Integer) {
            return intToDouble((int) value);
        } else if (value instanceof SafeInteger) {
            return safeIntegerToDouble((SafeInteger) value);
        } else {
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static int specializeImplicitDouble(Object value) {
        if (value instanceof Double) {
            return 0b1;
        } else if (value instanceof Integer) {
            return 0b10;
        } else if (value instanceof SafeInteger) {
            return 0b100;
        } else {
            return 0;
        }
    }

}
