// CheckStyle: start generated
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.runtime.interop.ScopeVariables.IsMemberModifiable;
import com.oracle.truffle.js.runtime.interop.ScopeVariables.IsMemberReadable;
import com.oracle.truffle.js.runtime.interop.ScopeVariables.ReadMember;
import com.oracle.truffle.js.runtime.interop.ScopeVariables.ResolvedSlot;
import com.oracle.truffle.js.runtime.interop.ScopeVariables.WriteMember;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

@GeneratedBy(ScopeVariables.class)
@SuppressWarnings("javadoc")
final class ScopeVariablesGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(ScopeVariables.class, new InteropLibraryExports());
    }

    private ScopeVariablesGen() {
    }

    @GeneratedBy(ScopeVariables.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, ScopeVariables.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof ScopeVariables;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof ScopeVariables;
            return new Cached(receiver);
        }

        @GeneratedBy(ScopeVariables.class)
        private static final class Cached extends InteropLibrary {

            static final ReferenceField<IsMemberReadableCachedData> IS_MEMBER_READABLE_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "isMemberReadable_cached_cache", IsMemberReadableCachedData.class);
            static final ReferenceField<IsMemberModifiableCachedData> IS_MEMBER_MODIFIABLE_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "isMemberModifiable_cached_cache", IsMemberModifiableCachedData.class);
            static final ReferenceField<ReadMemberCachedData> READ_MEMBER_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "readMember_cached_cache", ReadMemberCachedData.class);
            static final ReferenceField<WriteMemberCachedData> WRITE_MEMBER_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeMember_cached_cache", WriteMemberCachedData.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IsMemberReadable#doCached}
             *   1: SpecializationActive {@link IsMemberReadable#doGeneric}
             *   2: SpecializationActive {@link IsMemberModifiable#doCached}
             *   3: SpecializationActive {@link IsMemberModifiable#doGeneric}
             *   4: SpecializationActive {@link ReadMember#doCached}
             *   5: SpecializationActive {@link ReadMember#doGeneric}
             *   6: SpecializationActive {@link WriteMember#doCached}
             *   7: SpecializationActive {@link WriteMember#doGeneric}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @CompilationFinal private IsMemberReadableCachedData isMemberReadable_cached_cache;
            @UnsafeAccessedField @CompilationFinal private IsMemberModifiableCachedData isMemberModifiable_cached_cache;
            @UnsafeAccessedField @Child private ReadMemberCachedData readMember_cached_cache;
            @UnsafeAccessedField @Child private WriteMemberCachedData writeMember_cached_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ScopeVariables#accepts(ScopeVariables, Node, boolean)}
             *   Parameter: {@link Node} cachedNode</pre>
             */
            @CompilationFinal private Node acceptsNode__accepts_cachedNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ScopeVariables#accepts(ScopeVariables, Node, boolean)}
             *   Parameter: boolean cachedNodeEnter</pre>
             */
            @CompilationFinal private boolean acceptsNode__accepts_cachedNodeEnter_;

            protected Cached(Object receiver) {
                ScopeVariables castReceiver = ((ScopeVariables) receiver) ;
                VarHandle.storeStoreFence();
                this.acceptsNode__accepts_cachedNode_ = (castReceiver.blockOrRoot);
                this.acceptsNode__accepts_cachedNodeEnter_ = (castReceiver.nodeEnter);
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof ScopeVariables) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ScopeVariables && accepts_(receiver);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsMemberReadable#doCached}
             *     Activation probability: 0.13000
             *     With/without class size: 6/5 bytes
             *   Specialization {@link IsMemberReadable#doGeneric}
             *     Activation probability: 0.07000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                ScopeVariables arg0Value = ((ScopeVariables) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[ScopeVariables.IsMemberReadable.doCached(ScopeVariables, String, String, boolean)] || SpecializationActive[ScopeVariables.IsMemberReadable.doGeneric(ScopeVariables, String)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[ScopeVariables.IsMemberReadable.doCached(ScopeVariables, String, String, boolean)] */) {
                        IsMemberReadableCachedData s0_ = this.isMemberReadable_cached_cache;
                        while (s0_ != null) {
                            if ((s0_.cachedMember_.equals(arg1Value))) {
                                return IsMemberReadable.doCached(arg0Value, arg1Value, s0_.cachedMember_, s0_.cachedResult_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ScopeVariables.IsMemberReadable.doGeneric(ScopeVariables, String)] */) {
                        return IsMemberReadable.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableAndSpecialize(ScopeVariables arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[ScopeVariables.IsMemberReadable.doGeneric(ScopeVariables, String)] */) {
                    while (true) {
                        int count0_ = 0;
                        IsMemberReadableCachedData s0_ = IS_MEMBER_READABLE_CACHED_CACHE_UPDATER.getVolatile(this);
                        IsMemberReadableCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.cachedMember_.equals(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (s0_.cachedMember_.equals(arg1Value));
                            if (count0_ < (ScopeVariables.LIMIT)) {
                                s0_ = new IsMemberReadableCachedData(s0_original);
                                s0_.cachedMember_ = (arg1Value);
                                s0_.cachedResult_ = (IsMemberReadable.doGeneric(arg0Value, arg1Value));
                                if (!IS_MEMBER_READABLE_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1 /* add SpecializationActive[ScopeVariables.IsMemberReadable.doCached(ScopeVariables, String, String, boolean)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            return IsMemberReadable.doCached(arg0Value, arg1Value, s0_.cachedMember_, s0_.cachedResult_);
                        }
                        break;
                    }
                }
                this.isMemberReadable_cached_cache = null;
                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[ScopeVariables.IsMemberReadable.doCached(ScopeVariables, String, String, boolean)] */;
                state_0 = state_0 | 0b10 /* add SpecializationActive[ScopeVariables.IsMemberReadable.doGeneric(ScopeVariables, String)] */;
                this.state_0_ = state_0;
                return IsMemberReadable.doGeneric(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsMemberModifiable#doCached}
             *     Activation probability: 0.13000
             *     With/without class size: 6/5 bytes
             *   Specialization {@link IsMemberModifiable#doGeneric}
             *     Activation probability: 0.07000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                ScopeVariables arg0Value = ((ScopeVariables) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1100) != 0 /* is SpecializationActive[ScopeVariables.IsMemberModifiable.doCached(ScopeVariables, String, String, boolean)] || SpecializationActive[ScopeVariables.IsMemberModifiable.doGeneric(ScopeVariables, String)] */) {
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[ScopeVariables.IsMemberModifiable.doCached(ScopeVariables, String, String, boolean)] */) {
                        IsMemberModifiableCachedData s0_ = this.isMemberModifiable_cached_cache;
                        while (s0_ != null) {
                            if ((s0_.cachedMember_.equals(arg1Value))) {
                                return IsMemberModifiable.doCached(arg0Value, arg1Value, s0_.cachedMember_, s0_.cachedResult_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ScopeVariables.IsMemberModifiable.doGeneric(ScopeVariables, String)] */) {
                        return IsMemberModifiable.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberModifiableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableAndSpecialize(ScopeVariables arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[ScopeVariables.IsMemberModifiable.doGeneric(ScopeVariables, String)] */) {
                    while (true) {
                        int count0_ = 0;
                        IsMemberModifiableCachedData s0_ = IS_MEMBER_MODIFIABLE_CACHED_CACHE_UPDATER.getVolatile(this);
                        IsMemberModifiableCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.cachedMember_.equals(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (s0_.cachedMember_.equals(arg1Value));
                            if (count0_ < (ScopeVariables.LIMIT)) {
                                s0_ = new IsMemberModifiableCachedData(s0_original);
                                s0_.cachedMember_ = (arg1Value);
                                s0_.cachedResult_ = (IsMemberModifiable.doGeneric(arg0Value, arg1Value));
                                if (!IS_MEMBER_MODIFIABLE_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100 /* add SpecializationActive[ScopeVariables.IsMemberModifiable.doCached(ScopeVariables, String, String, boolean)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            return IsMemberModifiable.doCached(arg0Value, arg1Value, s0_.cachedMember_, s0_.cachedResult_);
                        }
                        break;
                    }
                }
                this.isMemberModifiable_cached_cache = null;
                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[ScopeVariables.IsMemberModifiable.doCached(ScopeVariables, String, String, boolean)] */;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[ScopeVariables.IsMemberModifiable.doGeneric(ScopeVariables, String)] */;
                this.state_0_ = state_0;
                return IsMemberModifiable.doGeneric(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadMember#doCached}
             *     Activation probability: 0.13000
             *     With/without class size: 8/12 bytes
             *   Specialization {@link ReadMember#doGeneric}
             *     Activation probability: 0.07000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                ScopeVariables arg0Value = ((ScopeVariables) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b110000) != 0 /* is SpecializationActive[ScopeVariables.ReadMember.doCached(ScopeVariables, String, String, ResolvedSlot, JavaScriptNode)] || SpecializationActive[ScopeVariables.ReadMember.doGeneric(ScopeVariables, String)] */) {
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ScopeVariables.ReadMember.doCached(ScopeVariables, String, String, ResolvedSlot, JavaScriptNode)] */) {
                        ReadMemberCachedData s0_ = this.readMember_cached_cache;
                        while (s0_ != null) {
                            if ((s0_.cachedMember_.equals(arg1Value))) {
                                return ReadMember.doCached(arg0Value, arg1Value, s0_.cachedMember_, s0_.resolvedSlot_, s0_.readNode_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ScopeVariables.ReadMember.doGeneric(ScopeVariables, String)] */) {
                        return ReadMember.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberAndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberAndSpecialize(ScopeVariables arg0Value, String arg1Value) throws UnknownIdentifierException {
                int state_0 = this.state_0_;
                if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[ScopeVariables.ReadMember.doGeneric(ScopeVariables, String)] */) {
                    while (true) {
                        int count0_ = 0;
                        ReadMemberCachedData s0_ = READ_MEMBER_CACHED_CACHE_UPDATER.getVolatile(this);
                        ReadMemberCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.cachedMember_.equals(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (s0_.cachedMember_.equals(arg1Value));
                            if (count0_ < (ScopeVariables.LIMIT)) {
                                s0_ = this.insert(new ReadMemberCachedData(s0_original));
                                s0_.cachedMember_ = (arg1Value);
                                s0_.resolvedSlot_ = (ScopeVariables.findSlot(arg1Value, arg0Value));
                                s0_.readNode_ = s0_.insert((ScopeVariables.findReadNode(s0_.resolvedSlot_)));
                                if (!READ_MEMBER_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[ScopeVariables.ReadMember.doCached(ScopeVariables, String, String, ResolvedSlot, JavaScriptNode)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            return ReadMember.doCached(arg0Value, arg1Value, s0_.cachedMember_, s0_.resolvedSlot_, s0_.readNode_);
                        }
                        break;
                    }
                }
                this.readMember_cached_cache = null;
                state_0 = state_0 & 0xffffffef /* remove SpecializationActive[ScopeVariables.ReadMember.doCached(ScopeVariables, String, String, ResolvedSlot, JavaScriptNode)] */;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[ScopeVariables.ReadMember.doGeneric(ScopeVariables, String)] */;
                this.state_0_ = state_0;
                return ReadMember.doGeneric(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteMember#doCached}
             *     Activation probability: 0.13000
             *     With/without class size: 8/12 bytes
             *   Specialization {@link WriteMember#doGeneric}
             *     Activation probability: 0.07000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                ScopeVariables arg0Value = ((ScopeVariables) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b11000000) != 0 /* is SpecializationActive[ScopeVariables.WriteMember.doCached(ScopeVariables, String, Object, String, ResolvedSlot, WriteNode)] || SpecializationActive[ScopeVariables.WriteMember.doGeneric(ScopeVariables, String, Object)] */) {
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ScopeVariables.WriteMember.doCached(ScopeVariables, String, Object, String, ResolvedSlot, WriteNode)] */) {
                        WriteMemberCachedData s0_ = this.writeMember_cached_cache;
                        while (s0_ != null) {
                            if ((s0_.cachedMember_.equals(arg1Value))) {
                                WriteMember.doCached(arg0Value, arg1Value, arg2Value, s0_.cachedMember_, s0_.resolvedSlot_, s0_.writeNode_);
                                return;
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ScopeVariables.WriteMember.doGeneric(ScopeVariables, String, Object)] */) {
                        WriteMember.doGeneric(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeMemberAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeMemberAndSpecialize(ScopeVariables arg0Value, String arg1Value, Object arg2Value) throws UnknownIdentifierException {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[ScopeVariables.WriteMember.doGeneric(ScopeVariables, String, Object)] */) {
                    while (true) {
                        int count0_ = 0;
                        WriteMemberCachedData s0_ = WRITE_MEMBER_CACHED_CACHE_UPDATER.getVolatile(this);
                        WriteMemberCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.cachedMember_.equals(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (s0_.cachedMember_.equals(arg1Value));
                            if (count0_ < (ScopeVariables.LIMIT)) {
                                s0_ = this.insert(new WriteMemberCachedData(s0_original));
                                s0_.cachedMember_ = (arg1Value);
                                s0_.resolvedSlot_ = (ScopeVariables.findSlot(arg1Value, arg0Value));
                                s0_.writeNode_ = DSLSupport.maybeInsert(s0_, (ScopeVariables.findWriteNode(s0_.resolvedSlot_)));
                                if (!WRITE_MEMBER_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[ScopeVariables.WriteMember.doCached(ScopeVariables, String, Object, String, ResolvedSlot, WriteNode)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            WriteMember.doCached(arg0Value, arg1Value, arg2Value, s0_.cachedMember_, s0_.resolvedSlot_, s0_.writeNode_);
                            return;
                        }
                        break;
                    }
                }
                this.writeMember_cached_cache = null;
                state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[ScopeVariables.WriteMember.doCached(ScopeVariables, String, Object, String, ResolvedSlot, WriteNode)] */;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[ScopeVariables.WriteMember.doGeneric(ScopeVariables, String, Object)] */;
                this.state_0_ = state_0;
                WriteMember.doGeneric(arg0Value, arg1Value, arg2Value);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ScopeVariables#accepts(ScopeVariables, Node, boolean)}
             *     Activation probability: 0.20000
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            private boolean accepts_(Object arg0Value_) {
                ScopeVariables arg0Value = ((ScopeVariables) arg0Value_);
                return arg0Value.accepts(this.acceptsNode__accepts_cachedNode_, this.acceptsNode__accepts_cachedNodeEnter_);
            }

            @Override
            public boolean isScope(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((ScopeVariables) receiver)).isScope();
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((ScopeVariables) receiver)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((ScopeVariables) receiver)).getLanguage();
            }

            @TruffleBoundary
            @Override
            public boolean hasScopeParent(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((ScopeVariables) receiver)).hasScopeParent();
            }

            @TruffleBoundary
            @Override
            public Object getScopeParent(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((ScopeVariables) receiver)).getScopeParent();
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((ScopeVariables) receiver)).hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((ScopeVariables) receiver)).getMembers(includeInternal);
            }

            @Override
            public boolean isMemberInsertable(Object receiver, String member) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((ScopeVariables) receiver)).isMemberInsertable(member);
            }

            @TruffleBoundary
            @Override
            public boolean hasSourceLocation(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((ScopeVariables) receiver)).hasSourceLocation();
            }

            @TruffleBoundary
            @Override
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((ScopeVariables) receiver)).getSourceLocation();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((ScopeVariables) receiver)).toDisplayString(allowSideEffects);
            }

            @GeneratedBy(ScopeVariables.class)
            @DenyReplace
            private static final class IsMemberReadableCachedData implements SpecializationDataNode {

                @CompilationFinal final IsMemberReadableCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberReadable#doCached}
                 *   Parameter: {@link String} cachedMember</pre>
                 */
                @CompilationFinal String cachedMember_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberReadable#doCached}
                 *   Parameter: boolean cachedResult</pre>
                 */
                @CompilationFinal boolean cachedResult_;

                IsMemberReadableCachedData(IsMemberReadableCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ScopeVariables.class)
            @DenyReplace
            private static final class IsMemberModifiableCachedData implements SpecializationDataNode {

                @CompilationFinal final IsMemberModifiableCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberModifiable#doCached}
                 *   Parameter: {@link String} cachedMember</pre>
                 */
                @CompilationFinal String cachedMember_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberModifiable#doCached}
                 *   Parameter: boolean cachedResult</pre>
                 */
                @CompilationFinal boolean cachedResult_;

                IsMemberModifiableCachedData(IsMemberModifiableCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ScopeVariables.class)
            @DenyReplace
            private static final class ReadMemberCachedData extends Node implements SpecializationDataNode {

                @Child ReadMemberCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReadMember#doCached}
                 *   Parameter: {@link String} cachedMember</pre>
                 */
                @CompilationFinal String cachedMember_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReadMember#doCached}
                 *   Parameter: {@link ResolvedSlot} resolvedSlot</pre>
                 */
                @CompilationFinal ResolvedSlot resolvedSlot_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReadMember#doCached}
                 *   Parameter: {@link JavaScriptNode} readNode</pre>
                 */
                @Child JavaScriptNode readNode_;

                ReadMemberCachedData(ReadMemberCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ScopeVariables.class)
            @DenyReplace
            private static final class WriteMemberCachedData extends Node implements SpecializationDataNode {

                @Child WriteMemberCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link WriteMember#doCached}
                 *   Parameter: {@link String} cachedMember</pre>
                 */
                @CompilationFinal String cachedMember_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link WriteMember#doCached}
                 *   Parameter: {@link ResolvedSlot} resolvedSlot</pre>
                 */
                @CompilationFinal ResolvedSlot resolvedSlot_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link WriteMember#doCached}
                 *   Parameter: {@link WriteNode} writeNode</pre>
                 */
                @Child WriteNode writeNode_;

                WriteMemberCachedData(WriteMemberCachedData next_) {
                    this.next_ = next_;
                }

            }
        }
        @GeneratedBy(ScopeVariables.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof ScopeVariables) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ScopeVariables && accepts_(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ScopeVariables arg0Value = ((ScopeVariables) arg0Value_);
                return IsMemberReadable.doGeneric(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ScopeVariables arg0Value = ((ScopeVariables) arg0Value_);
                return IsMemberModifiable.doGeneric(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ScopeVariables arg0Value = ((ScopeVariables) arg0Value_);
                return ReadMember.doGeneric(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ScopeVariables arg0Value = ((ScopeVariables) arg0Value_);
                WriteMember.doGeneric(arg0Value, arg1Value, arg2Value);
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isScope(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables) receiver) .isScope();
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public boolean hasScopeParent(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables) receiver) .hasScopeParent();
            }

            @TruffleBoundary
            @Override
            public Object getScopeParent(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables) receiver) .getScopeParent();
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object receiver, String member) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables) receiver) .isMemberInsertable(member);
            }

            @TruffleBoundary
            @Override
            public boolean hasSourceLocation(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables) receiver) .hasSourceLocation();
            }

            @TruffleBoundary
            @Override
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables) receiver) .getSourceLocation();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables) receiver) .toDisplayString(allowSideEffects);
            }

            @TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                ScopeVariables arg0Value = ((ScopeVariables) arg0Value_);
                return arg0Value.accepts((arg0Value.blockOrRoot), (arg0Value.nodeEnter));
            }

        }
    }
}
