/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.io.ASObject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.granite.logging.Logger;
import org.granite.util.Introspector;
import org.granite.util.PropertyDescriptor;

public class ASRecordSet
extends ASObject {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ASRecordSet.class);
    public static final String SERVICE_NAME = "OpenAMFPageableRecordSet";
    private static final String SI = "serverInfo";
    private static final String SI_ID = "id";
    private static final String SI_TOTAL_COUNT = "totalCount";
    private static final String SI_INITIAL_DATA = "initialData";
    private static final String SI_CURSOR = "cursor";
    private static final String SI_SERVICE_NAME = "serviceName";
    private static final String SI_COLUMN_NAMES = "columnNames";
    private static final String SI_VERSION = "version";
    private static int count = 0;
    private Map<String, Object> serverInfo = new HashMap<String, Object>();
    private List<List<Object>> rows;
    private int initialRowCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASRecordSet() {
        super("RecordSet");
        this.put(SI, (Object)this.serverInfo);
        Class<ASRecordSet> clazz = ASRecordSet.class;
        synchronized (ASRecordSet.class) {
            this.setId("RS" + ++count);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.setInitialData(new ArrayList());
            this.setServiceName(SERVICE_NAME);
            this.setCursor(1);
            this.setVersion(1.0);
            this.rows = new ArrayList<List<Object>>();
            this.initialRowCount = 0;
            return;
        }
    }

    public String getId() {
        return (String)this.serverInfo.get(SI_ID);
    }

    public void setId(String id) {
        this.serverInfo.put(SI_ID, id);
    }

    public int getTotalCount() {
        Object value = this.serverInfo.get(SI_TOTAL_COUNT);
        if (value != null) {
            return (Integer)value;
        }
        return 0;
    }

    public void setTotalCount(int totalCount) {
        this.serverInfo.put(SI_TOTAL_COUNT, totalCount);
    }

    public List<?> getInitialData() {
        return (List)this.serverInfo.get(SI_INITIAL_DATA);
    }

    public void setInitialData(List<?> initialData) {
        this.serverInfo.put(SI_INITIAL_DATA, initialData);
    }

    public Map<String, Object> getRecords(int from, int count) {
        List<List<Object>> page = this.rows.subList(from - 1, from - 1 + count);
        HashMap<String, Object> records = new HashMap<String, Object>();
        records.put("Page", page);
        records.put("Cursor", from + 1);
        return records;
    }

    public int getCursor() {
        Object value = this.serverInfo.get(SI_CURSOR);
        if (value != null) {
            return (Integer)value;
        }
        return 0;
    }

    public void setCursor(int cursor) {
        this.serverInfo.put(SI_CURSOR, cursor);
    }

    public String getServiceName() {
        return (String)this.serverInfo.get(SI_SERVICE_NAME);
    }

    public void setServiceName(String serviceName) {
        this.serverInfo.put(SI_SERVICE_NAME, serviceName);
    }

    public String[] getColumnNames() {
        return (String[])this.serverInfo.get(SI_COLUMN_NAMES);
    }

    public void setColumnNames(String[] columnNames) {
        this.serverInfo.put(SI_COLUMN_NAMES, columnNames);
    }

    public double getVersion() {
        Object value = this.serverInfo.get(SI_VERSION);
        if (value != null) {
            return (Double)value;
        }
        return 0.0;
    }

    public void setVersion(double version) {
        this.serverInfo.put(SI_VERSION, new Double(version));
    }

    public List<List<Object>> rows() {
        return this.rows;
    }

    public void populate(ResultSet rs) throws IOException {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] columnNames = new String[columnCount];
            int rowIndex = 0;
            ArrayList initialData = new ArrayList();
            while (rs.next()) {
                ++rowIndex;
                ArrayList<Object> row = new ArrayList<Object>();
                for (int column = 0; column < columnCount; ++column) {
                    if (rowIndex == 1) {
                        columnNames[column] = rsmd.getColumnName(column + 1);
                    }
                    row.add(rs.getObject(column + 1));
                }
                if (rowIndex == 1) {
                    this.setColumnNames(columnNames);
                }
                this.rows.add(row);
                if (rowIndex > this.initialRowCount) continue;
                initialData.add(row);
            }
            this.setTotalCount(rowIndex);
            this.setInitialData(initialData);
            this.setColumnNames(columnNames);
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void populate(String[] columnNames, List<List<Object>> rows) {
        this.rows = rows;
        List<List<Object>> initialData = rows.subList(0, this.initialRowCount > rows.size() ? rows.size() : this.initialRowCount);
        this.setInitialData(initialData);
        this.setTotalCount(rows.size());
        this.setColumnNames(columnNames);
    }

    public void populate(List<?> list, String[] ignoreProperties) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> names = new ArrayList<String>();
        Object firstBean = list.get(0);
        PropertyDescriptor[] properties = Introspector.getPropertyDescriptors(firstBean.getClass());
        if (properties == null) {
            properties = new PropertyDescriptor[]{};
        }
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor descriptor = properties[i];
            if (this.ignoreProperty(descriptor, ignoreProperties)) continue;
            names.add(descriptor.getName());
        }
        String[] columnNames = new String[names.size()];
        columnNames = names.toArray(columnNames);
        this.setColumnNames(columnNames);
        int rowIndex = 0;
        ArrayList initialData = new ArrayList();
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            ++rowIndex;
            Object bean = iterator.next();
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 0; i < properties.length; ++i) {
                PropertyDescriptor descriptor = properties[i];
                if (this.ignoreProperty(descriptor, ignoreProperties)) continue;
                Object value = null;
                Method readMethod = descriptor.getReadMethod();
                if (readMethod != null) {
                    value = readMethod.invoke(bean, new Object[0]);
                }
                row.add(value);
            }
            this.rows.add(row);
            if (rowIndex > this.initialRowCount) continue;
            initialData.add(row);
        }
        this.setInitialData(initialData);
        this.setTotalCount(this.rows.size());
        log.debug("%s", this);
    }

    private boolean ignoreProperty(PropertyDescriptor descriptor, String[] ignoreProperties) {
        boolean ignore = false;
        if (descriptor.getName().equals("class")) {
            ignore = true;
        } else {
            for (int i = 0; i < ignoreProperties.length; ++i) {
                String ignoreProp = ignoreProperties[i];
                if (!ignoreProp.equals(descriptor.getName())) continue;
                log.debug("Ignoring %s", descriptor.getName());
                ignore = true;
                break;
            }
        }
        return ignore;
    }

    @Override
    public String toString() {
        StringBuffer info = new StringBuffer();
        this.addInfo(info, SI_ID, this.getId());
        this.addInfo(info, SI_TOTAL_COUNT, this.getTotalCount());
        this.addInfo(info, SI_CURSOR, this.getCursor());
        this.addInfo(info, SI_SERVICE_NAME, this.getServiceName());
        this.addInfo(info, SI_VERSION, this.getVersion());
        StringBuffer names = new StringBuffer();
        String[] columnNames = this.getColumnNames();
        if (columnNames != null) {
            for (int i = 0; i < columnNames.length; ++i) {
                String name = columnNames[i];
                if (i > 0) {
                    names.append(", ");
                }
                names.append(name);
            }
        }
        this.addInfo(info, SI_COLUMN_NAMES, names);
        this.addInfo(info, SI_INITIAL_DATA, this.getInitialData().toString());
        return info.toString();
    }

    private void addInfo(StringBuffer info, String name, int value) {
        this.addInfo(info, name, new Integer(value));
    }

    private void addInfo(StringBuffer info, String name, double value) {
        this.addInfo(info, name, new Double(value));
    }

    private void addInfo(StringBuffer info, String name, Object value) {
        info.append(name);
        info.append(" = ");
        info.append(value);
        info.append('\n');
    }
}

