/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.configuration;

import java.io.IOException;
import java.io.InputStream;
import org.granite.client.configuration.ClientGraniteConfig;
import org.granite.client.configuration.ClientServicesConfig;
import org.granite.client.configuration.Configuration;
import org.granite.client.messaging.codec.MessagingCodec;
import org.granite.config.Config;

public class SimpleConfiguration
implements Configuration {
    private String graniteStdConfigPath = SimpleConfiguration.class.getPackage().getName().replace('.', '/') + "/granite-config.xml";
    private String graniteConfigPath = null;
    private ClientGraniteConfig graniteConfig = null;
    private Object servicesConfig = null;
    private MessagingCodec.ClientType clientType = MessagingCodec.ClientType.AS3;

    public SimpleConfiguration() {
    }

    public SimpleConfiguration(String graniteStdConfigPath, String graniteConfigPath) {
        this.graniteStdConfigPath = graniteStdConfigPath;
        this.graniteConfigPath = graniteConfigPath;
    }

    @Override
    public MessagingCodec.ClientType getClientType() {
        return this.clientType;
    }

    @Override
    public void setClientType(MessagingCodec.ClientType clientType) {
        this.clientType = clientType;
    }

    public void setGraniteStdConfigPath(String graniteConfigPath) {
        this.graniteStdConfigPath = graniteConfigPath;
    }

    public void setGraniteConfigPath(String graniteConfigPath) {
        this.graniteConfigPath = graniteConfigPath;
    }

    @Override
    public boolean isLoaded() {
        return this.graniteConfig != null;
    }

    @Override
    public void load() {
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.graniteStdConfigPath);
            if (this.graniteConfigPath != null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.graniteConfigPath);
            }
            this.graniteConfig = new ClientGraniteConfig(this.graniteStdConfigPath, is, null, null);
            this.postLoad(this.graniteConfig);
            this.servicesConfig = new ClientServicesConfig();
        }
        catch (Exception e) {
            this.graniteConfig = null;
            this.servicesConfig = null;
            throw new RuntimeException("Cannot load configuration", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void postLoad(ClientGraniteConfig graniteConfig) {
    }

    @Override
    public <C extends Config> C getGraniteConfig() {
        return (C)this.graniteConfig;
    }

    @Override
    public <C extends Config> C getServicesConfig() {
        return (C)((Config)this.servicesConfig);
    }
}

