/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel;

import flex.messaging.messages.Message;
import org.granite.client.configuration.Configuration;
import org.granite.client.messaging.channel.AbstractChannelFactory;
import org.granite.client.messaging.channel.RemotingChannel;
import org.granite.client.messaging.channel.amf.AMFRemotingChannel;
import org.granite.client.messaging.codec.AMF0MessagingCodec;
import org.granite.client.messaging.codec.AMF3MessagingCodec;
import org.granite.client.messaging.codec.MessagingCodec;
import org.granite.client.messaging.transport.Transport;
import org.granite.client.platform.Platform;
import org.granite.config.api.AliasRegistryConfig;
import org.granite.messaging.amf.AMF0Message;
import org.granite.util.ContentType;

public class AMFChannelFactory
extends AbstractChannelFactory {
    private final Configuration defaultConfiguration;

    public AMFChannelFactory() {
        this((Object)null, null, null, null);
    }

    public AMFChannelFactory(Object context) {
        this(context, null, null, null);
    }

    public AMFChannelFactory(Object context, Configuration defaultConfiguration) {
        this(context, null, null, defaultConfiguration);
    }

    public AMFChannelFactory(Object context, Transport remotingTransport, Transport messagingTransport) {
        this(context, remotingTransport, messagingTransport, null);
    }

    public AMFChannelFactory(Object context, Transport remotingTransport, Transport messagingTransport, Configuration defaultConfiguration) {
        super(ContentType.AMF, context, remotingTransport, messagingTransport);
        Configuration configuration = this.defaultConfiguration = defaultConfiguration != null ? defaultConfiguration : Platform.getInstance().newConfiguration();
        if (!this.defaultConfiguration.isLoaded()) {
            this.defaultConfiguration.load();
        }
        this.aliasRegistry = ((AliasRegistryConfig)this.defaultConfiguration.getGraniteConfig()).getAliasRegistry();
    }

    @Override
    protected Class<? extends RemotingChannel> getRemotingChannelClass() {
        return AMFRemotingChannel.class;
    }

    @Override
    protected <M> MessagingCodec<M> newMessagingCodec(Class<M> messageClass) {
        if (messageClass == Message[].class) {
            return new AMF3MessagingCodec(this.defaultConfiguration);
        }
        if (messageClass == AMF0Message.class) {
            return new AMF0MessagingCodec(this.defaultConfiguration);
        }
        throw new IllegalArgumentException("Unknown message class " + messageClass);
    }

    public Configuration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }
}

