/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.granite.client.messaging.codec.MessagingCodec;
import org.granite.client.messaging.jmf.ClientSharedContext;
import org.granite.messaging.amf.AMF0Message;
import org.granite.messaging.jmf.JMFDeserializer;
import org.granite.messaging.jmf.JMFSerializer;
import org.granite.util.ContentType;

public class JMFAMF0MessagingCodec
implements MessagingCodec<AMF0Message> {
    private final ClientSharedContext sharedContext;

    public JMFAMF0MessagingCodec(ClientSharedContext sharedContext) {
        this.sharedContext = sharedContext;
    }

    @Override
    public MessagingCodec.ClientType getClientType() {
        return MessagingCodec.ClientType.JAVA;
    }

    @Override
    public String getContentType() {
        return ContentType.JMF_AMF.mimeType();
    }

    @Override
    public void encode(AMF0Message message, OutputStream output) throws IOException {
        JMFSerializer serializer = new JMFSerializer(output, this.sharedContext);
        serializer.writeObject(message);
    }

    @Override
    public AMF0Message decode(InputStream input) throws IOException {
        JMFDeserializer deserializer = new JMFDeserializer(input, this.sharedContext);
        try {
            return (AMF0Message)deserializer.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }
}

