/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.transport;

import java.util.ArrayList;
import java.util.List;
import org.granite.client.messaging.transport.Transport;
import org.granite.client.messaging.transport.TransportStatusHandler;
import org.granite.client.messaging.transport.TransportStopListener;

public abstract class AbstractTransport<C>
implements Transport {
    private volatile C context;
    private volatile TransportStatusHandler statusHandler = new TransportStatusHandler.LogEngineStatusHandler();
    protected final List<TransportStopListener> stopListeners = new ArrayList<TransportStopListener>();

    public AbstractTransport() {
    }

    public AbstractTransport(C context) {
        this.context = context;
    }

    @Override
    public void setContext(Object context) {
        this.context = context;
    }

    public C getContext() {
        return this.context;
    }

    @Override
    public void setStatusHandler(TransportStatusHandler statusHandler) {
        if (statusHandler == null) {
            statusHandler = new TransportStatusHandler.NoopEngineStatusHandler();
        }
        this.statusHandler = statusHandler;
    }

    @Override
    public TransportStatusHandler getStatusHandler() {
        return this.statusHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStopListener(TransportStopListener listener) {
        List<TransportStopListener> list = this.stopListeners;
        synchronized (list) {
            if (!this.stopListeners.contains(listener)) {
                this.stopListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeStopListener(TransportStopListener listener) {
        List<TransportStopListener> list = this.stopListeners;
        synchronized (list) {
            return this.stopListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        List<TransportStopListener> list = this.stopListeners;
        synchronized (list) {
            for (TransportStopListener listener : this.stopListeners) {
                try {
                    listener.onStop(this);
                }
                catch (Exception e) {}
            }
            this.stopListeners.clear();
        }
    }
}

