/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.transport.apache;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.granite.client.messaging.channel.Channel;
import org.granite.client.messaging.transport.AbstractTransport;
import org.granite.client.messaging.transport.TransportException;
import org.granite.client.messaging.transport.TransportFuture;
import org.granite.client.messaging.transport.TransportHttpStatusException;
import org.granite.client.messaging.transport.TransportIOException;
import org.granite.client.messaging.transport.TransportMessage;
import org.granite.client.messaging.transport.TransportStateException;
import org.granite.logging.Logger;
import org.granite.util.PublicByteArrayOutputStream;

public class ApacheAsyncTransport
extends AbstractTransport<Object> {
    private static final Logger log = Logger.getLogger(ApacheAsyncTransport.class);
    private CloseableHttpAsyncClient httpClient = null;
    private RequestConfig defaultRequestConfig = null;
    private BasicCookieStore cookieStore = new BasicCookieStore();

    public void configure(HttpAsyncClientBuilder clientBuilder) {
    }

    public RequestConfig getDefaultRequestConfig() {
        return this.defaultRequestConfig;
    }

    public void setDefaultRequestConfig(RequestConfig defaultRequestConfig) {
        this.defaultRequestConfig = defaultRequestConfig;
    }

    protected synchronized CloseableHttpAsyncClient getCloseableHttpAsyncClient() {
        return this.httpClient;
    }

    @Override
    public boolean isReconnectAfterReceive() {
        return true;
    }

    @Override
    public synchronized boolean start() {
        if (this.httpClient != null) {
            return true;
        }
        log.info("Starting Apache HttpAsyncClient transport...", new Object[0]);
        try {
            if (this.defaultRequestConfig == null) {
                this.defaultRequestConfig = RequestConfig.custom().setCookieSpec("compatibility").build();
            }
            HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClients.custom();
            httpClientBuilder.setDefaultCookieStore((CookieStore)this.cookieStore);
            httpClientBuilder.setDefaultRequestConfig(this.defaultRequestConfig);
            this.configure(httpClientBuilder);
            this.httpClient = httpClientBuilder.build();
            this.httpClient.start();
            log.info("Apache HttpAsyncClient transport started.", new Object[0]);
            return true;
        }
        catch (Exception e) {
            this.httpClient = null;
            this.getStatusHandler().handleException(new TransportException("Could not start Apache HttpAsyncClient", e));
            log.error(e, "Apache HttpAsyncClient failed to start.", new Object[0]);
            return false;
        }
    }

    @Override
    public synchronized boolean isStarted() {
        return this.httpClient != null;
    }

    @Override
    public TransportFuture send(final Channel channel, final TransportMessage message) throws TransportException {
        CloseableHttpAsyncClient httpClient = this.getCloseableHttpAsyncClient();
        if (httpClient == null) {
            TransportStateException e = new TransportStateException("Apache HttpAsyncClient not started");
            this.getStatusHandler().handleException(e);
            throw e;
        }
        if (!message.isConnect()) {
            this.getStatusHandler().handleIO(true);
        }
        try {
            HttpPost request = new HttpPost(channel.getUri());
            request.setHeader("Content-Type", message.getContentType());
            request.setHeader("GDSClientType", message.getClientType().toString());
            PublicByteArrayOutputStream os = new PublicByteArrayOutputStream(512);
            try {
                message.encode(os);
            }
            catch (IOException e) {
                throw new TransportException("Message serialization failed: " + message.getId(), e);
            }
            request.setEntity((HttpEntity)new ByteArrayEntity(os.getBytes(), 0, os.size()));
            final Future future = httpClient.execute((HttpUriRequest)request, (FutureCallback)new FutureCallback<HttpResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed(HttpResponse response) {
                    if (!message.isConnect()) {
                        ApacheAsyncTransport.this.getStatusHandler().handleIO(false);
                    }
                    if (message.isDisconnect()) {
                        channel.onDisconnect();
                        return;
                    }
                    if (response.getStatusLine().getStatusCode() != 200) {
                        channel.onError(message, new TransportHttpStatusException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                        return;
                    }
                    InputStream is = null;
                    try {
                        is = response.getEntity().getContent();
                        channel.onMessage(message, is);
                    }
                    catch (Exception e) {
                        ApacheAsyncTransport.this.getStatusHandler().handleException(new TransportIOException(message, "Could not deserialize message", e));
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }

                public void failed(Exception e) {
                    if (!message.isConnect()) {
                        ApacheAsyncTransport.this.getStatusHandler().handleIO(false);
                    }
                    if (message.isDisconnect()) {
                        channel.onDisconnect();
                        return;
                    }
                    channel.onError(message, e);
                    ApacheAsyncTransport.this.getStatusHandler().handleException(new TransportIOException(message, "Request failed", e));
                }

                public void cancelled() {
                    if (!message.isConnect()) {
                        ApacheAsyncTransport.this.getStatusHandler().handleIO(false);
                    }
                    if (message.isDisconnect()) {
                        channel.onDisconnect();
                        return;
                    }
                    channel.onCancelled(message);
                }
            });
            return new TransportFuture(){

                @Override
                public boolean cancel() {
                    boolean cancelled = false;
                    try {
                        cancelled = future.cancel(true);
                    }
                    catch (Exception e) {
                        log.error(e, "Cancel request failed", new Object[0]);
                    }
                    return cancelled;
                }
            };
        }
        catch (Exception e) {
            if (!message.isConnect()) {
                this.getStatusHandler().handleIO(false);
            }
            TransportIOException f = new TransportIOException(message, "Request failed", e);
            this.getStatusHandler().handleException(f);
            throw f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.httpClient == null) {
            return;
        }
        log.info("Stopping Apache HttpAsyncClient transport...", new Object[0]);
        super.stop();
        try {
            this.httpClient.close();
        }
        catch (Exception e) {
            this.getStatusHandler().handleException(new TransportException("Could not stop Apache HttpAsyncClient", e));
            log.error(e, "Apache HttpAsyncClient failed to stop properly.", new Object[0]);
        }
        finally {
            this.httpClient = null;
        }
        log.info("Apache HttpAsyncClient transport stopped.", new Object[0]);
    }
}

