/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.transport.jetty;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketClient;
import org.eclipse.jetty.websocket.WebSocketClientFactory;
import org.granite.client.messaging.channel.Channel;
import org.granite.client.messaging.transport.TransportException;
import org.granite.client.messaging.transport.TransportMessage;
import org.granite.client.messaging.transport.websocket.AbstractWebSocketTransport;
import org.granite.logging.Logger;

public class JettyWebSocketTransport
extends AbstractWebSocketTransport<WebSocket.Connection> {
    private static final Logger log = Logger.getLogger(JettyWebSocketTransport.class);
    private WebSocketClientFactory webSocketClientFactory = null;

    @Override
    public synchronized boolean start() {
        if (this.isStarted()) {
            return true;
        }
        log.info("Starting Jetty WebSocketClient transport...", new Object[0]);
        try {
            this.webSocketClientFactory = new WebSocketClientFactory();
            this.webSocketClientFactory.setBufferSize(4096);
            this.webSocketClientFactory.start();
            long timeout = System.currentTimeMillis() + 10000L;
            while (!this.webSocketClientFactory.isStarted()) {
                if (System.currentTimeMillis() > timeout) {
                    throw new TimeoutException("Jetty WebSocketFactory start process too long");
                }
                Thread.sleep(100L);
            }
            log.info("Jetty WebSocketClient transport started.", new Object[0]);
            return true;
        }
        catch (Exception e) {
            this.webSocketClientFactory = null;
            this.getStatusHandler().handleException(new TransportException("Could not start Jetty WebSocketFactory", e));
            log.error(e, "Jetty WebSocketClient transport failed to start.", new Object[0]);
            return false;
        }
    }

    @Override
    public synchronized boolean isStarted() {
        return this.webSocketClientFactory != null && this.webSocketClientFactory.isStarted();
    }

    @Override
    public void connect(Channel channel, TransportMessage transportMessage) {
        URI uri = channel.getUri();
        try {
            WebSocketClient webSocketClient = this.webSocketClientFactory.newWebSocketClient();
            webSocketClient.setMaxIdleTime(this.getMaxIdleTime());
            webSocketClient.setMaxTextMessageSize(1024);
            webSocketClient.setMaxBinaryMessageSize(this.getMaxMessageSize());
            webSocketClient.setProtocol("org.granite.gravity." + transportMessage.getContentType().substring("application/x-".length()));
            if (transportMessage.getSessionId() != null) {
                webSocketClient.getCookies().put("JSESSIONID", transportMessage.getSessionId());
            }
            String u = uri.toString();
            u = u + "?connectId=" + transportMessage.getId() + "&GDSClientType=" + (Object)((Object)transportMessage.getClientType());
            if (transportMessage.getClientId() != null) {
                u = u + "&GDSClientId=" + transportMessage.getClientId();
            } else if (channel.getClientId() != null) {
                u = u + "&GDSClientId=" + channel.getClientId();
            }
            log.info("Connecting to websocket %s protocol %s sessionId %s", u, webSocketClient.getProtocol(), transportMessage.getSessionId());
            webSocketClient.open(new URI(u), (WebSocket)new WebSocketHandler(channel));
        }
        catch (Exception e) {
            this.getStatusHandler().handleException(new TransportException("Could not connect to uri " + channel.getUri(), e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.webSocketClientFactory == null) {
            return;
        }
        log.info("Stopping Jetty WebSocketClient transport...", new Object[0]);
        super.stop();
        try {
            this.setStopping(true);
            this.webSocketClientFactory.stop();
        }
        catch (Exception e) {
            this.getStatusHandler().handleException(new TransportException("Could not stop Jetty WebSocketFactory", e));
            log.error(e, "Jetty WebSocketClient failed to stop properly.", new Object[0]);
        }
        finally {
            this.webSocketClientFactory = null;
            this.setStopping(false);
        }
        log.info("Jetty WebSocketClient transport stopped.", new Object[0]);
    }

    @Override
    public AbstractWebSocketTransport.TransportData<WebSocket.Connection> newTransportData() {
        return new JettyTransportData();
    }

    private class WebSocketHandler
    implements WebSocket.OnBinaryMessage {
        private final Channel channel;

        public WebSocketHandler(Channel channel) {
            this.channel = channel;
        }

        public void onOpen(WebSocket.Connection connection) {
            JettyWebSocketTransport.this.onConnect(this.channel, connection);
        }

        public void onMessage(byte[] data, int offset, int length) {
            JettyWebSocketTransport.this.onBinaryMessage(this.channel, data, offset, length);
        }

        public void onClose(int closeCode, String message) {
            JettyWebSocketTransport.this.onClose(this.channel, closeCode, message);
        }
    }

    private static class JettyTransportData
    extends AbstractWebSocketTransport.TransportData<WebSocket.Connection> {
        private WebSocket.Connection connection = null;

        private JettyTransportData() {
        }

        @Override
        public void connect(WebSocket.Connection connection) {
            this.connection = connection;
        }

        @Override
        public boolean isConnected() {
            return this.connection != null;
        }

        @Override
        public void disconnect() {
            this.connection = null;
        }

        @Override
        public void sendBytes(byte[] data) throws IOException {
            this.connection.sendMessage(data, 0, data.length);
        }
    }
}

