/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.persistence.collection;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.granite.client.persistence.LazyInitializationException;
import org.granite.client.persistence.Loader;
import org.granite.client.persistence.collection.PersistentCollection;
import org.granite.logging.Logger;
import org.granite.messaging.persistence.PersistentCollectionSnapshot;
import org.granite.util.TypeUtil;

public abstract class AbstractPersistentCollection<C>
implements PersistentCollection<C> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AbstractPersistentCollection.class);
    private volatile C collection = null;
    private volatile boolean dirty = false;
    private volatile String detachedState = null;
    private Loader<C> loader = new DefaultCollectionLoader();
    private List<PersistentCollection.ChangeListener<C>> changeListeners = new ArrayList<PersistentCollection.ChangeListener<C>>();
    private List<PersistentCollection.InitializationListener<C>> initializationListeners = new ArrayList<PersistentCollection.InitializationListener<C>>();

    protected AbstractPersistentCollection() {
    }

    protected void init(C collection, String detachedState, boolean dirty) {
        this.collection = collection;
        if (detachedState != null) {
            this.detachedState = detachedState;
        }
        this.dirty = dirty;
    }

    @Override
    public Loader<C> getLoader() {
        return this.loader;
    }

    @Override
    public void setLoader(Loader<C> loader) {
        this.loader = loader;
    }

    protected boolean checkInitializedRead() {
        if (this.wasInitialized()) {
            return true;
        }
        this.loader.load(this, null);
        return false;
    }

    protected void checkInitializedWrite() {
        if (!this.wasInitialized()) {
            throw new LazyInitializationException(this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        }
    }

    protected C getCollection() {
        return this.collection;
    }

    public String getDetachedState() {
        return this.detachedState;
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public boolean wasInitialized() {
        return this.collection != null;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void dirty() {
        this.dirty = true;
        for (PersistentCollection.ChangeListener<C> listener : this.changeListeners) {
            listener.changed(this);
        }
    }

    @Override
    public void clearDirty() {
        this.dirty = false;
    }

    @Override
    public PersistentCollection<C> clone(boolean uninitialize) {
        try {
            AbstractPersistentCollection collection = TypeUtil.newInstance(this.getClass(), AbstractPersistentCollection.class);
            if (this.wasInitialized() && !uninitialize) {
                collection.init(this.getCollection(), this.getDetachedState(), this.isDirty());
            }
            return collection;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not clone collection " + this.getClass().getName(), e);
        }
    }

    protected abstract PersistentCollectionSnapshot createSnapshot(Object var1, boolean var2);

    protected abstract void updateFromSnapshot(ObjectInput var1, PersistentCollectionSnapshot var2);

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PersistentCollectionSnapshot snapshot = this.createSnapshot(out, false);
        snapshot.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PersistentCollectionSnapshot snapshot = this.createSnapshot(in, true);
        snapshot.readExternal(in);
        this.updateFromSnapshot(in, snapshot);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {initialized=" + this.wasInitialized() + ", dirty=" + this.isDirty() + "}" + (this.collection != null ? ": " + this.collection.toString() : "");
    }

    @Override
    public void addListener(PersistentCollection.ChangeListener<C> listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    @Override
    public void removeListener(PersistentCollection.ChangeListener<C> listener) {
        this.changeListeners.remove(listener);
    }

    @Override
    public void addListener(PersistentCollection.InitializationListener<C> listener) {
        if (!this.initializationListeners.contains(listener)) {
            this.initializationListeners.add(listener);
        }
    }

    @Override
    public void removeListener(PersistentCollection.InitializationListener<C> listener) {
        this.initializationListeners.remove(listener);
    }

    @Override
    public void initializing() {
        this.loader.onInitializing();
    }

    @Override
    public void initialize(C content, PersistentCollection.Initializer<C> initializer) {
        this.loader.onInitialize();
        this.doInitialize(content, initializer != null);
        if (initializer != null) {
            initializer.initialize(content);
        }
        for (PersistentCollection.InitializationListener<C> listener : this.initializationListeners) {
            listener.initialized(this);
        }
        log.debug("initialized", new Object[0]);
    }

    protected abstract void doInitialize(C var1, boolean var2);

    @Override
    public void uninitialize() {
        this.loader.onUninitialize();
        for (PersistentCollection.InitializationListener<C> listener : this.initializationListeners) {
            listener.uninitialized(this);
        }
        this.collection = null;
        log.debug("uninitialized", new Object[0]);
    }

    @Override
    public void withInitialized(PersistentCollection.InitializationCallback<C> callback) {
        if (this.wasInitialized()) {
            callback.call(this);
        } else {
            this.loader.load(this, callback);
        }
    }

    private static class DefaultCollectionLoader<C>
    implements Loader<C> {
        private DefaultCollectionLoader() {
        }

        @Override
        public void load(PersistentCollection<C> collection, PersistentCollection.InitializationCallback<C> callback) {
            throw new LazyInitializationException(collection.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(collection)));
        }

        @Override
        public void onInitializing() {
        }

        @Override
        public void onInitialize() {
        }

        @Override
        public void onUninitialize() {
        }
    }

    class SortedMapProxy<K, V>
    implements SortedMap<K, V> {
        protected final SortedMap<K, V> sortedMap;

        public SortedMapProxy(SortedMap<K, V> sortedMap) {
            this.sortedMap = sortedMap;
        }

        @Override
        public int size() {
            return this.sortedMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.sortedMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.sortedMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.sortedMap.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.sortedMap.get(key);
        }

        @Override
        public V put(K key, V value) {
            boolean containsKey = this.sortedMap.containsKey(key);
            V previousValue = this.sortedMap.put(key, value);
            if (!containsKey || (previousValue == null ? value != null : !previousValue.equals(value))) {
                AbstractPersistentCollection.this.dirty();
            }
            return previousValue;
        }

        @Override
        public V remove(Object key) {
            boolean containsKey = this.sortedMap.containsKey(key);
            Object removedValue = this.sortedMap.remove(key);
            if (containsKey) {
                AbstractPersistentCollection.this.dirty();
            }
            return removedValue;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            if (!this.sortedMap.isEmpty()) {
                this.sortedMap.clear();
                AbstractPersistentCollection.this.dirty();
            }
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap.comparator();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return new SortedMapProxy<K, V>(this.sortedMap.subMap(fromKey, toKey));
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return new SortedMapProxy<K, V>(this.sortedMap.headMap(toKey));
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return new SortedMapProxy<K, V>(this.sortedMap.tailMap(fromKey));
        }

        @Override
        public K firstKey() {
            return this.sortedMap.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sortedMap.lastKey();
        }

        @Override
        public Set<K> keySet() {
            return new SetProxy<K>(this.sortedMap.keySet());
        }

        @Override
        public Collection<V> values() {
            return new CollectionProxy<V>(this.sortedMap.values());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new SetProxy<Map.Entry<K, V>>(this.sortedMap.entrySet());
        }

        @Override
        public int hashCode() {
            return this.sortedMap.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.sortedMap.equals(obj);
        }
    }

    class SortedSetProxy<E>
    extends SetProxy<E>
    implements SortedSet<E> {
        public SortedSetProxy(SortedSet<E> collection) {
            super(collection);
        }

        @Override
        public Comparator<? super E> comparator() {
            return ((SortedSet)this.collection).comparator();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return new SortedSetProxy<E>(((SortedSet)this.collection).subSet(fromElement, toElement));
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return new SortedSetProxy<E>(((SortedSet)this.collection).headSet(toElement));
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return new SortedSetProxy<E>(((SortedSet)this.collection).tailSet(fromElement));
        }

        @Override
        public E first() {
            return ((SortedSet)this.collection).first();
        }

        @Override
        public E last() {
            return ((SortedSet)this.collection).last();
        }
    }

    class ListProxy<E>
    extends CollectionProxy<E>
    implements List<E> {
        public ListProxy(List<E> collection) {
            super(collection);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            if (((List)this.collection).addAll(index, c)) {
                AbstractPersistentCollection.this.dirty();
                return true;
            }
            return false;
        }

        @Override
        public E get(int index) {
            return ((List)this.collection).get(index);
        }

        @Override
        public E set(int index, E element) {
            E previousElement = ((List)this.collection).set(index, element);
            if (previousElement == null ? element != null : !previousElement.equals(element)) {
                AbstractPersistentCollection.this.dirty();
            }
            return previousElement;
        }

        @Override
        public void add(int index, E element) {
            ((List)this.collection).add(index, element);
            AbstractPersistentCollection.this.dirty();
        }

        @Override
        public E remove(int index) {
            Object removedElement = ((List)this.collection).remove(index);
            AbstractPersistentCollection.this.dirty();
            return removedElement;
        }

        @Override
        public int indexOf(Object o) {
            return ((List)this.collection).indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((List)this.collection).lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new ListIteratorProxy(((List)this.collection).listIterator(index));
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new ListProxy(((List)this.collection).subList(fromIndex, toIndex));
        }
    }

    class SetProxy<E>
    extends CollectionProxy<E>
    implements Set<E> {
        public SetProxy(Set<E> collection) {
            super(collection);
        }
    }

    class CollectionProxy<E>
    implements Collection<E> {
        protected final Collection<E> collection;

        public CollectionProxy(Collection<E> collection) {
            this.collection = collection;
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.collection.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return new IteratorProxy<E>(this.collection.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.collection.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.collection.toArray(a);
        }

        @Override
        public boolean add(E e) {
            if (this.collection.add(e)) {
                AbstractPersistentCollection.this.dirty();
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (this.collection.remove(o)) {
                AbstractPersistentCollection.this.dirty();
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.collection.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            if (this.collection.addAll(c)) {
                AbstractPersistentCollection.this.dirty();
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (this.collection.removeAll(c)) {
                AbstractPersistentCollection.this.dirty();
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (this.collection.retainAll(c)) {
                AbstractPersistentCollection.this.dirty();
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            if (!this.collection.isEmpty()) {
                this.collection.clear();
                AbstractPersistentCollection.this.dirty();
            }
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.collection.equals(obj);
        }
    }

    class ListIteratorProxy<E>
    implements ListIterator<E> {
        private final ListIterator<E> iterator;
        private E lastNextOrPrevious = null;

        public ListIteratorProxy(ListIterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            if (!AbstractPersistentCollection.this.checkInitializedRead()) {
                return null;
            }
            this.lastNextOrPrevious = this.iterator.next();
            return this.lastNextOrPrevious;
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public E previous() {
            if (!AbstractPersistentCollection.this.checkInitializedRead()) {
                return null;
            }
            this.lastNextOrPrevious = this.iterator.previous();
            return this.lastNextOrPrevious;
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            AbstractPersistentCollection.this.checkInitializedWrite();
            this.iterator.remove();
            this.lastNextOrPrevious = null;
            AbstractPersistentCollection.this.dirty();
        }

        @Override
        public void set(E e) {
            AbstractPersistentCollection.this.checkInitializedWrite();
            this.iterator.set(e);
            if (e == null ? this.lastNextOrPrevious != null : !e.equals(this.lastNextOrPrevious)) {
                AbstractPersistentCollection.this.dirty();
            }
        }

        @Override
        public void add(E e) {
            AbstractPersistentCollection.this.checkInitializedWrite();
            this.iterator.add(e);
            this.lastNextOrPrevious = null;
            AbstractPersistentCollection.this.dirty();
        }

        public int hashCode() {
            return this.iterator.hashCode();
        }

        public boolean equals(Object obj) {
            return this.iterator.equals(obj);
        }
    }

    class IteratorProxy<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;

        public IteratorProxy(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            if (!AbstractPersistentCollection.this.checkInitializedRead()) {
                return null;
            }
            return this.iterator.next();
        }

        @Override
        public void remove() {
            AbstractPersistentCollection.this.checkInitializedWrite();
            this.iterator.remove();
            AbstractPersistentCollection.this.dirty();
        }

        public int hashCode() {
            return this.iterator.hashCode();
        }

        public boolean equals(Object obj) {
            return this.iterator.equals(obj);
        }
    }
}

