/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.persistence.collection;

import java.io.ObjectInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.granite.client.persistence.collection.AbstractPersistentCollection;
import org.granite.client.persistence.collection.AbstractPersistentSimpleCollection;
import org.granite.messaging.persistence.PersistentCollectionSnapshot;

public class PersistentList<E>
extends AbstractPersistentSimpleCollection<E, List<E>>
implements List<E> {
    private static final long serialVersionUID = 1L;

    public PersistentList() {
    }

    public PersistentList(boolean initialized) {
        this(initialized ? new ArrayList() : null, false);
    }

    public PersistentList(List<E> collection) {
        this(collection, true);
    }

    public PersistentList(List<E> collection, boolean clone) {
        if (collection != null) {
            this.init(clone ? new ArrayList(collection) : collection, null, false);
        }
    }

    @Override
    public void doInitialize(List<E> list, boolean empty) {
        this.init(empty ? new ArrayList() : list, null, false);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkInitializedWrite();
        if (((List)this.getCollection()).addAll(index, c)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public E get(int index) {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return ((List)this.getCollection()).get(index);
    }

    @Override
    public E set(int index, E element) {
        this.checkInitializedWrite();
        E previousElement = ((List)this.getCollection()).set(index, element);
        if (previousElement == null ? element != null : !previousElement.equals(element)) {
            this.dirty();
        }
        return previousElement;
    }

    @Override
    public void add(int index, E element) {
        this.checkInitializedWrite();
        ((List)this.getCollection()).add(index, element);
        this.dirty();
    }

    @Override
    public E remove(int index) {
        this.checkInitializedWrite();
        Object previousElement = ((List)this.getCollection()).remove(index);
        this.dirty();
        return previousElement;
    }

    @Override
    public int indexOf(Object o) {
        if (!this.checkInitializedRead()) {
            return -1;
        }
        return ((List)this.getCollection()).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!this.checkInitializedRead()) {
            return -1;
        }
        return ((List)this.getCollection()).lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new AbstractPersistentCollection.ListIteratorProxy(((List)this.getCollection()).listIterator(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return (AbstractPersistentCollection)this.new AbstractPersistentCollection.ListProxy(((List)this.getCollection()).subList(fromIndex, toIndex));
    }

    @Override
    protected void updateFromSnapshot(ObjectInput in, PersistentCollectionSnapshot snapshot) {
        if (snapshot.isInitialized()) {
            this.init(new ArrayList(snapshot.getElementsAsCollection()), snapshot.getDetachedState(), snapshot.isDirty());
        } else {
            this.init(null, snapshot.getDetachedState(), false);
        }
    }

    @Override
    public PersistentList<E> clone(boolean uninitialize) {
        PersistentList<E> list = new PersistentList<E>();
        if (this.wasInitialized() && !uninitialize) {
            list.init(this.getCollection(), null, this.isDirty());
        }
        return list;
    }
}

