/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.persistence.collection;

import java.io.ObjectInput;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.granite.client.persistence.collection.AbstractPersistentSimpleCollection;
import org.granite.messaging.persistence.PersistentCollectionSnapshot;

public class PersistentSet<E>
extends AbstractPersistentSimpleCollection<E, Set<E>>
implements Set<E> {
    private static final long serialVersionUID = 1L;

    public PersistentSet() {
    }

    public PersistentSet(boolean initialized) {
        this(initialized ? new HashSet() : null, false);
    }

    public PersistentSet(Set<E> collection) {
        this(collection, true);
    }

    public PersistentSet(Set<E> collection, boolean clone) {
        if (collection instanceof SortedSet) {
            throw new IllegalArgumentException("Should not be a SortedSet: " + collection);
        }
        if (collection != null) {
            this.init(clone ? new HashSet(collection) : collection, null, false);
        }
    }

    @Override
    public void doInitialize(Set<E> set, boolean empty) {
        this.init(empty ? new HashSet() : set, null, false);
    }

    @Override
    protected void updateFromSnapshot(ObjectInput in, PersistentCollectionSnapshot snapshot) {
        if (snapshot.isInitialized()) {
            this.init(new HashSet(snapshot.getElementsAsCollection()), snapshot.getDetachedState(), snapshot.isDirty());
        } else {
            this.init(null, snapshot.getDetachedState(), false);
        }
    }

    @Override
    public PersistentSet<E> clone(boolean uninitialize) {
        PersistentSet<E> set = new PersistentSet<E>();
        if (this.wasInitialized() && !uninitialize) {
            set.init(this.getCollection(), null, this.isDirty());
        }
        return set;
    }
}

