/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.scan;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import net.sf.extcos.ComponentQuery;
import net.sf.extcos.ComponentScanner;
import net.sf.extcos.spi.ResourceAccessor;
import net.sf.extcos.spi.ResourceType;
import org.granite.client.configuration.ClassScanner;
import org.granite.client.messaging.RemoteAlias;
import org.granite.client.scan.JavaResourceAccessor;

public class ExtCosClassScanner
implements ClassScanner {
    @Override
    public Set<Class<?>> scan(Set<String> packageNames, Class<? extends Annotation> annotationClass) {
        ComponentScanner scanner = new ComponentScanner();
        final String[] basePackageNames = packageNames.toArray(new String[packageNames.size()]);
        Set classes = scanner.getClasses(new ComponentQuery(){

            protected void query() {
                this.select(new ResourceType[]{JavaClassResourceType.javaClasses()}).from(basePackageNames).returning(this.allAnnotatedWith(RemoteAlias.class));
            }
        });
        HashSet annotatedClasses = new HashSet();
        for (Class cls : classes) {
            if (!cls.isAnnotationPresent(annotationClass)) continue;
            annotatedClasses.add(cls);
        }
        return annotatedClasses;
    }

    public static class JavaClassResourceType
    implements ResourceType {
        private static final String JAVA_CLASS_SUFFIX = "class";
        private static JavaClassResourceType instance;

        private JavaClassResourceType() {
        }

        public String getFileSuffix() {
            return JAVA_CLASS_SUFFIX;
        }

        public static JavaClassResourceType javaClasses() {
            if (instance == null) {
                instance = new JavaClassResourceType();
            }
            return instance;
        }

        public ResourceAccessor getResourceAccessor() {
            return new JavaResourceAccessor();
        }
    }
}

