/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.scan;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.extcos.internal.ArraySet;
import net.sf.extcos.spi.AnnotationMetadata;
import net.sf.extcos.spi.ClassLoaderHolder;
import net.sf.extcos.spi.ResourceAccessor;
import net.sf.extcos.util.Assert;
import net.sf.extcos.util.ClassUtils;
import net.sf.extcos.util.StringUtils;
import org.granite.logging.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class JavaResourceAccessor
implements ResourceAccessor {
    private static Logger logger = Logger.getLogger(JavaResourceAccessor.class);
    private static Method defineClass;
    private static Method resolveClass;
    private static final int ASM_FLAGS = 7;
    private byte[] resourceBytes;
    private URL resourceUrl;
    private String className;
    private Map<String, AnnotationMetadata> annotations;
    private Set<String> interfaces;
    private Set<String> superClasses;
    private boolean isClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> generateClass() {
        if (!this.isClass) {
            return null;
        }
        Class clazz = null;
        ClassLoader loader = ClassLoaderHolder.getClassLoader();
        try {
            defineClass.setAccessible(true);
            resolveClass.setAccessible(true);
            clazz = (Class)defineClass.invoke((Object)loader, this.className, this.resourceBytes, 0, this.resourceBytes.length);
            resolveClass.invoke((Object)loader, clazz);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof LinkageError) {
                try {
                    clazz = Class.forName(this.className, true, loader);
                }
                catch (ClassNotFoundException e1) {
                    logger.error(StringUtils.append((String[])new String[]{"Error creating class from URL [", this.resourceUrl.toString(), "]"}), e1);
                }
            } else {
                logger.error(StringUtils.append((String[])new String[]{"Error creating class from URL [", this.resourceUrl.toString(), "]"}), e.getCause());
            }
        }
        catch (Exception e) {
            logger.error(StringUtils.append((String[])new String[]{"Error creating class from URL [", this.resourceUrl.toString(), "]"}), e);
        }
        finally {
            defineClass.setAccessible(false);
            resolveClass.setAccessible(false);
        }
        return clazz;
    }

    public AnnotationMetadata getAnnotationMetadata(Class<? extends Annotation> annotation) {
        if (this.isClass && this.annotations != null && this.annotations.containsKey(annotation.getCanonicalName())) {
            return this.annotations.get(annotation.getCanonicalName());
        }
        return null;
    }

    public boolean hasInterface(Class<?> interfaze) {
        if (this.isClass && this.interfaces != null) {
            return this.interfaces.contains(interfaze.getCanonicalName());
        }
        return false;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isSubclassOf(Class<?> clazz) {
        if (clazz == Object.class) {
            return true;
        }
        if (this.isClass && this.superClasses != null) {
            return this.superClasses.contains(clazz.getCanonicalName());
        }
        return false;
    }

    public void setResourceUrl(URL resourceUrl) {
        Assert.notNull((Object)resourceUrl, (Class)Assert.iae());
        try {
            this.resourceBytes = this.readBytes(resourceUrl);
            this.resourceUrl = resourceUrl;
            this.readClassData();
        }
        catch (IOException e) {
            this.isClass = false;
            logger.error("Error reading resource", e);
        }
    }

    private byte[] readBytes(URL resourceUrl) throws IOException {
        int readByte;
        BufferedInputStream classStream = new BufferedInputStream(resourceUrl.openStream());
        ArrayList<Byte> buffer = new ArrayList<Byte>();
        while ((readByte = ((InputStream)classStream).read()) != -1) {
            buffer.add((byte)readByte);
        }
        byte[] bytes = new byte[buffer.size()];
        for (int i = 0; i < buffer.size(); ++i) {
            bytes[i] = (Byte)buffer.get(i);
        }
        return bytes;
    }

    private void readClassData() {
        BooleanHolder isClassHolder = new BooleanHolder();
        NameHolder nameHolder = new NameHolder();
        ClassReader reader = new ClassReader(this.resourceBytes);
        reader.accept((ClassVisitor)new GeneralVisitor(nameHolder, isClassHolder), 7);
        this.isClass = isClassHolder.value;
        if (this.isClass) {
            this.className = ClassUtils.convertResourcePathToClassName((String)nameHolder.name);
        } else {
            this.annotations = null;
            this.interfaces = null;
            this.superClasses = null;
            this.resourceBytes = null;
            this.resourceUrl = null;
        }
    }

    private void readSuperClasses(String superName) {
        if (!"java/lang/Object".equals(superName)) {
            if (this.superClasses == null) {
                this.superClasses = new ArraySet();
            }
            String superClass = ClassUtils.convertResourcePathToClassName((String)superName);
            this.superClasses.add(superClass);
            try {
                ClassReader reader = new ClassReader(superClass);
                reader.accept((ClassVisitor)new AnnotatedClassVisitor(){

                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        JavaResourceAccessor.this.readSuperClasses(superName);
                    }

                    @Override
                    protected boolean shouldVisitAnnotation(boolean visible) {
                        return visible;
                    }
                }, 7);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void readInterfaces(String superName, String[] interfaces) {
        if (this.interfaces == null && interfaces.length > 0) {
            this.interfaces = new ArraySet();
        }
        for (String interfaze : interfaces) {
            this.interfaces.add(ClassUtils.convertResourcePathToClassName((String)interfaze));
            this.readSuperInterfaces(interfaze);
        }
        this.readInheritedInterfaces(superName);
    }

    private void readInheritedInterfaces(String superName) {
        if ("java/lang/Object".equals(superName)) {
            return;
        }
        this.readSuperInterfaces(superName);
    }

    private void readSuperInterfaces(String type) {
        try {
            ClassReader reader = new ClassReader(ClassUtils.convertResourcePathToClassName((String)type));
            reader.accept((ClassVisitor)new EmptyVisitor(){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    JavaResourceAccessor.this.readInterfaces(superName, interfaces);
                }
            }, 7);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Class<?> cl = Class.forName("java.lang.ClassLoader");
                    defineClass = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                    resolveClass = cl.getDeclaredMethod("resolveClass", Class.class);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("cannot initialize Java Resource Accessor", pae.getException());
        }
    }

    private class AnnotationMetadataImpl
    implements AnnotationMetadata {
        private final Map<String, Object> parameters = new HashMap<String, Object>();

        private AnnotationMetadataImpl() {
        }

        public Object getValue(String key) {
            return this.parameters.get(key);
        }

        public boolean hasKey(String key) {
            return this.parameters.containsKey(key);
        }

        protected void putParameter(String key, Object value) {
            this.parameters.put(key, value);
        }
    }

    private class AnnotationVisitorImpl
    extends EmptyVisitor {
        private final AnnotationMetadataImpl metadata;
        private final String className;

        private AnnotationVisitorImpl(String desc) {
            this.metadata = new AnnotationMetadataImpl();
            this.className = Type.getType((String)desc).getClassName();
        }

        public void visit(String name, Object value) {
            this.metadata.putParameter(name, value);
        }

        public void visitEnum(String name, String desc, String value) {
            try {
                String enumName = Type.getType((String)desc).getClassName();
                Class<?> enumClass = ClassLoaderHolder.getClassLoader().loadClass(enumName);
                Method valueOf = enumClass.getDeclaredMethod("valueOf", String.class);
                Object object = valueOf.invoke(null, value);
                this.metadata.putParameter(name, object);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public void visitEnd() {
            try {
                Method[] annotationAttributes;
                Class<?> annotationClass = ClassLoaderHolder.getClassLoader().loadClass(this.className);
                for (Method annotationAttribute : annotationAttributes = annotationClass.getMethods()) {
                    String attributeName = annotationAttribute.getName();
                    Object defaultValue = annotationAttribute.getDefaultValue();
                    if (defaultValue == null || this.metadata.hasKey(attributeName)) continue;
                    this.metadata.putParameter(attributeName, defaultValue);
                }
                JavaResourceAccessor.this.annotations.put(this.className, this.metadata);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private class GeneralVisitor
    extends AnnotatedClassVisitor {
        private final NameHolder nameHolder;
        private final BooleanHolder isClassHolder;

        private GeneralVisitor(NameHolder nameHolder, BooleanHolder isClassHolder) {
            this.nameHolder = nameHolder;
            this.isClassHolder = isClassHolder;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (!Modifier.isAbstract(access) && !Modifier.isInterface(access)) {
                this.isClassHolder.value = true;
                this.nameHolder.name = name;
                JavaResourceAccessor.this.readInterfaces(superName, interfaces);
                JavaResourceAccessor.this.readSuperClasses(superName);
            }
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (this.isClassHolder.value && this.nameHolder.name != null && this.nameHolder.name.equals(name)) {
                this.isClassHolder.value = false;
            }
        }

        public void visitOuterClass(String owner, String name, String desc) {
            this.isClassHolder.value = false;
        }

        @Override
        protected boolean shouldVisitAnnotation(boolean visible) {
            return this.isClassHolder.value && visible;
        }
    }

    private abstract class AnnotatedClassVisitor
    extends EmptyVisitor {
        private AnnotatedClassVisitor() {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (this.shouldVisitAnnotation(visible)) {
                if (JavaResourceAccessor.this.annotations == null) {
                    JavaResourceAccessor.this.annotations = new HashMap();
                }
                return new AnnotationVisitorImpl(desc);
            }
            return null;
        }

        protected abstract boolean shouldVisitAnnotation(boolean var1);
    }

    private class NameHolder {
        String name;

        private NameHolder() {
        }
    }

    private class BooleanHolder {
        boolean value;

        private BooleanHolder() {
        }
    }
}

