/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.scan;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.granite.client.configuration.ClassScanner;
import org.granite.logging.Logger;
import org.granite.scan.ScannedItem;
import org.granite.scan.ScannedItemHandler;
import org.granite.scan.Scanner;
import org.granite.scan.ScannerFactory;

public class StandardClassScanner
implements ClassScanner {
    private static final Logger log = Logger.getLogger(StandardClassScanner.class);

    @Override
    public Set<Class<?>> scan(Set<String> packageNames, Class<? extends Annotation> annotationClass) {
        HashSet classes = new HashSet();
        Scanner scanner = ScannerFactory.createScanner(new MessagingScannedItemHandler(packageNames, classes, annotationClass), null);
        try {
            scanner.scan();
        }
        catch (Exception e) {
            log.error(e, "Could not scan classpath for @RemoteAlias", new Object[0]);
        }
        return classes;
    }

    class MessagingScannedItemHandler
    implements ScannedItemHandler {
        final String[] packageNames;
        final Set<Class<?>> classes;
        final Class<? extends Annotation> annotationClass;

        MessagingScannedItemHandler(Set<String> packageNames, Set<Class<?>> classes, Class<? extends Annotation> annotationClass) {
            this.packageNames = new String[packageNames.size()];
            int i = 0;
            for (String packageName : packageNames) {
                this.packageNames[i++] = packageName.replace('.', '/') + '/';
            }
            this.classes = classes;
            this.annotationClass = annotationClass;
        }

        @Override
        public boolean handleMarkerItem(ScannedItem item) {
            return false;
        }

        @Override
        public void handleScannedItem(ScannedItem item) {
            if ("class".equals(item.getExtension())) {
                boolean scan = false;
                String path = item.getRelativePath();
                for (String packageName : this.packageNames) {
                    if (!path.startsWith(packageName)) continue;
                    scan = true;
                    break;
                }
                if (scan) {
                    try {
                        Class<?> cls = item.loadAsClass();
                        if (cls.isAnnotationPresent(this.annotationClass)) {
                            this.classes.add(cls);
                        }
                    }
                    catch (ClassFormatError e) {
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (IOException e) {
                        log.error(e, "Could not load class: %s", item);
                    }
                }
            }
        }
    }
}

