/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.util;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public abstract class BeanUtil {
    public static PropertyDescriptor[] getProperties(Class<?> clazz) {
        try {
            Field[] fields;
            PropertyDescriptor[] properties = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!Boolean.class.equals(field.getType())) continue;
                boolean found = false;
                for (PropertyDescriptor property : properties) {
                    if (!property.getName().equals(field.getName())) continue;
                    found = true;
                    if (property.getReadMethod() != null) break;
                    try {
                        Method readMethod = clazz.getDeclaredMethod(BeanUtil.getIsMethodName(field.getName()), new Class[0]);
                        if (!Modifier.isPublic(readMethod.getModifiers()) || Modifier.isStatic(readMethod.getModifiers())) break;
                        property.setReadMethod(readMethod);
                    }
                    catch (NoSuchMethodException e) {}
                    break;
                }
                if (found) continue;
                try {
                    Method readMethod = clazz.getDeclaredMethod(BeanUtil.getIsMethodName(field.getName()), new Class[0]);
                    if (!Modifier.isPublic(readMethod.getModifiers()) || Modifier.isStatic(readMethod.getModifiers())) continue;
                    PropertyDescriptor[] propertiesTmp = new PropertyDescriptor[properties.length + 1];
                    System.arraycopy(properties, 0, propertiesTmp, 0, properties.length);
                    propertiesTmp[properties.length] = new PropertyDescriptor(field.getName(), readMethod, null);
                    properties = propertiesTmp;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not introspect properties of class: " + clazz, e);
        }
    }

    private static String getIsMethodName(String name) {
        return "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

