/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.PrimitiveArrayCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractArrayCodec;
import org.granite.messaging.jmf.codec.std.impl.util.DoubleUtil;
import org.granite.messaging.jmf.codec.std.impl.util.FloatUtil;
import org.granite.messaging.jmf.codec.std.impl.util.IntegerUtil;
import org.granite.messaging.jmf.codec.std.impl.util.LongUtil;

public class PrimitiveArrayCodecImpl
extends AbstractArrayCodec
implements PrimitiveArrayCodec {
    protected static final boolean[] BOOLEAN_0 = new boolean[0];
    protected static final char[] CHARACTER_0 = new char[0];
    protected static final byte[] BYTE_0 = new byte[0];
    protected static final short[] SHORT_0 = new short[0];
    protected static final int[] INTEGER_0 = new int[0];
    protected static final long[] LONG_0 = new long[0];
    protected static final float[] FLOAT_0 = new float[0];
    protected static final double[] DOUBLE_0 = new double[0];

    @Override
    public int getObjectType() {
        return 5;
    }

    @Override
    public boolean canEncode(Object v) {
        return v.getClass().isArray() && this.getComponentType(v).isPrimitive();
    }

    @Override
    public void encode(OutputContext ctx, Object v) throws IOException {
        int indexOfStoredObject = ctx.indexOfObject(v);
        if (indexOfStoredObject != -1) {
            int count = IntegerUtil.significantIntegerBytesCount0(indexOfStoredObject);
            ctx.getOutputStream().write(0x80 | count << 4 | 5);
            IntegerUtil.encodeInteger(ctx, indexOfStoredObject, count);
        } else {
            ctx.addToObjects(v);
            AbstractArrayCodec.ArrayStructure structure = new AbstractArrayCodec.ArrayStructure(v);
            int jmfComponentType = this.primitiveClassToJmfType(structure.componentType);
            int length = Array.getLength(v);
            int count = IntegerUtil.significantIntegerBytesCount0(length);
            OutputStream os = ctx.getOutputStream();
            if (structure.dimensions == 0) {
                os.write(count << 4 | 5);
                IntegerUtil.encodeInteger(ctx, length, count);
                os.write(jmfComponentType);
                this.writePrimitiveArrayContent0(ctx, v, jmfComponentType);
            } else {
                os.write(0x40 | count << 4 | 5);
                IntegerUtil.encodeInteger(ctx, length, count);
                os.write(jmfComponentType);
                os.write(structure.dimensions);
                this.writePrimitiveArrayContent(ctx, v, jmfComponentType, structure.dimensions);
            }
        }
    }

    protected void writePrimitiveArrayContent(OutputContext ctx, Object v, int jmfComponentType, int dimensions) throws IOException {
        int length = Array.getLength(v);
        if (length == 0) {
            return;
        }
        boolean writePrimitiveArray0 = --dimensions == 0;
        OutputStream os = ctx.getOutputStream();
        for (int index = 0; index < length; ++index) {
            Object component = Array.get(v, index);
            if (component == null) {
                os.write(120);
                continue;
            }
            int indexOfStoredObject = ctx.indexOfObject(component);
            if (indexOfStoredObject != -1) {
                int count = IntegerUtil.significantIntegerBytesCount0(indexOfStoredObject);
                ctx.getOutputStream().write(0x80 | count << 4 | 5);
                IntegerUtil.encodeInteger(ctx, indexOfStoredObject, count);
                continue;
            }
            ctx.addToObjects(component);
            int componentLength = Array.getLength(component);
            int count = IntegerUtil.significantIntegerBytesCount0(componentLength);
            os.write(count << 4 | 5);
            IntegerUtil.encodeInteger(ctx, componentLength, count);
            if (writePrimitiveArray0) {
                this.writePrimitiveArrayContent0(ctx, component, jmfComponentType);
                continue;
            }
            this.writePrimitiveArrayContent(ctx, component, jmfComponentType, dimensions);
        }
    }

    protected void writePrimitiveArrayContent0(OutputContext ctx, Object v, int jmfComponentType) throws IOException {
        switch (jmfComponentType) {
            case 56: {
                this.writeBooleanArrayContent0(ctx, (boolean[])v);
                break;
            }
            case 58: {
                this.writeCharacterArrayContent0(ctx, (char[])v);
                break;
            }
            case 123: {
                this.writeByteArrayContent0(ctx, (byte[])v);
                break;
            }
            case 24: {
                this.writeShortArrayContent0(ctx, (short[])v);
                break;
            }
            case 8: {
                this.writeIntegerArrayContent0(ctx, (int[])v);
                break;
            }
            case 2: {
                this.writeLongArrayContent0(ctx, (long[])v);
                break;
            }
            case 125: {
                this.writeFloatArrayContent0(ctx, (float[])v);
                break;
            }
            case 0: {
                this.writeDoubleArrayContent0(ctx, (double[])v);
                break;
            }
            default: {
                throw new JMFEncodingException("Unsupported primitive type: " + jmfComponentType);
            }
        }
    }

    protected void writeBooleanArrayContent0(OutputContext ctx, boolean[] v) throws IOException {
        if (v.length == 0) {
            return;
        }
        OutputStream os = ctx.getOutputStream();
        byte[] bytes = new byte[this.lengthOfBooleanArray(v.length)];
        int i = 0;
        int j = 0;
        for (boolean b : v) {
            if (b) {
                int n = i;
                bytes[n] = (byte)(bytes[n] | 128 >>> j);
            }
            if (++j < 8) continue;
            j = 0;
            ++i;
        }
        os.write(bytes);
    }

    protected void writeCharacterArrayContent0(OutputContext ctx, char[] v) throws IOException {
        if (v.length == 0) {
            return;
        }
        OutputStream os = ctx.getOutputStream();
        for (char c : v) {
            os.write(c >>> 8);
            os.write(c);
        }
    }

    protected void writeByteArrayContent0(OutputContext ctx, byte[] v) throws IOException {
        if (v.length == 0) {
            return;
        }
        ctx.getOutputStream().write(v);
    }

    protected void writeShortArrayContent0(OutputContext ctx, short[] v) throws IOException {
        if (v.length == 0) {
            return;
        }
        OutputStream os = ctx.getOutputStream();
        for (short s : v) {
            os.write(s >>> 8);
            os.write(s);
        }
    }

    protected void writeIntegerArrayContent0(OutputContext ctx, int[] v) throws IOException {
        if (v.length == 0) {
            return;
        }
        for (int i : v) {
            IntegerUtil.encodeVariableInteger(ctx, i);
        }
    }

    protected void writeLongArrayContent0(OutputContext ctx, long[] v) throws IOException {
        if (v.length == 0) {
            return;
        }
        for (long l : v) {
            LongUtil.encodeVariableLong(ctx, l);
        }
    }

    protected void writeFloatArrayContent0(OutputContext ctx, float[] v) throws IOException {
        if (v.length == 0) {
            return;
        }
        for (float f : v) {
            FloatUtil.encodeFloat(ctx, f);
        }
    }

    protected void writeDoubleArrayContent0(OutputContext ctx, double[] v) throws IOException {
        if (v.length == 0) {
            return;
        }
        for (double d : v) {
            DoubleUtil.encodeVariableDouble(ctx, d);
        }
    }

    @Override
    public Object decode(InputContext ctx, int parameterizedJmfType) throws IOException, ClassNotFoundException {
        Object v = null;
        int indexOrLength = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 4 & 3);
        if ((parameterizedJmfType & 0x80) != 0) {
            v = ctx.getObject(indexOrLength);
        } else {
            int jmfComponentType = ctx.safeRead();
            int dimensions = (parameterizedJmfType & 0x40) == 0 ? 0 : ctx.safeRead();
            Class<?> componentType = this.jmfTypeToPrimitiveClass(jmfComponentType);
            v = dimensions == 0 ? this.readPrimitiveArray0(ctx, componentType, jmfComponentType, indexOrLength) : this.readPrimitiveArray(ctx, componentType, jmfComponentType, indexOrLength, dimensions);
        }
        return v;
    }

    protected Object readPrimitiveArray(InputContext ctx, Class<?> componentType, int jmfComponentType, int length, int dimensions) throws IOException {
        Object v = this.newArray(componentType, length, dimensions);
        ctx.addToObjects(v);
        boolean readPrimitiveArray0 = --dimensions == 0;
        for (int index = 0; index < length; ++index) {
            int eltParameterizedJmfType = ctx.safeRead();
            if (eltParameterizedJmfType == 120) {
                Array.set(v, index, null);
                continue;
            }
            int eltIndexOrLength = IntegerUtil.decodeInteger(ctx, eltParameterizedJmfType >>> 4 & 3);
            if ((eltParameterizedJmfType & 0x80) != 0) {
                Array.set(v, index, ctx.getObject(eltIndexOrLength));
                continue;
            }
            if (readPrimitiveArray0) {
                Array.set(v, index, this.readPrimitiveArray0(ctx, componentType, jmfComponentType, eltIndexOrLength));
                continue;
            }
            Array.set(v, index, this.readPrimitiveArray(ctx, componentType, jmfComponentType, eltIndexOrLength, dimensions));
        }
        return v;
    }

    protected Object readPrimitiveArray0(InputContext ctx, Class<?> componentType, int jmfComponentType, int length) throws IOException {
        Object[] v = null;
        switch (jmfComponentType) {
            case 56: {
                v = this.readBooleanArray0(ctx, length);
                break;
            }
            case 58: {
                v = this.readCharacterArray0(ctx, length);
                break;
            }
            case 123: {
                v = this.readByteArray0(ctx, length);
                break;
            }
            case 24: {
                v = this.readShortArray0(ctx, length);
                break;
            }
            case 8: {
                v = this.readIntegerArray0(ctx, length);
                break;
            }
            case 2: {
                v = this.readLongArray0(ctx, length);
                break;
            }
            case 125: {
                v = this.readFloatArray0(ctx, length);
                break;
            }
            case 0: {
                v = this.readDoubleArray0(ctx, length);
                break;
            }
            default: {
                throw new JMFEncodingException("Unsupported primitive type: " + jmfComponentType);
            }
        }
        ctx.addToObjects(v);
        return v;
    }

    protected boolean[] readBooleanArray0(InputContext ctx, int length) throws IOException {
        if (length == 0) {
            return BOOLEAN_0;
        }
        boolean[] a = new boolean[length];
        int nb = this.lengthOfBooleanArray(length);
        for (int i = 0; i < nb; ++i) {
            int index;
            int b = ctx.safeRead();
            for (int j = 0; j < 8 && (index = i * 8 + j) < length; ++j) {
                a[index] = (b & 128 >>> j) != 0;
            }
        }
        return a;
    }

    protected char[] readCharacterArray0(InputContext ctx, int length) throws IOException {
        if (length == 0) {
            return CHARACTER_0;
        }
        char[] a = new char[length];
        for (int i = 0; i < length; ++i) {
            a[i] = (char)(ctx.safeRead() << 8 | ctx.safeRead());
        }
        return a;
    }

    protected byte[] readByteArray0(InputContext ctx, int length) throws IOException {
        if (length == 0) {
            return BYTE_0;
        }
        byte[] a = new byte[length];
        ctx.safeReadFully(a);
        return a;
    }

    protected short[] readShortArray0(InputContext ctx, int length) throws IOException {
        if (length == 0) {
            return SHORT_0;
        }
        short[] a = new short[length];
        for (int i = 0; i < length; ++i) {
            a[i] = (short)(ctx.safeRead() << 8 | ctx.safeRead());
        }
        return a;
    }

    protected int[] readIntegerArray0(InputContext ctx, int length) throws IOException {
        if (length == 0) {
            return INTEGER_0;
        }
        int[] a = new int[length];
        for (int i = 0; i < length; ++i) {
            a[i] = IntegerUtil.decodeVariableInteger(ctx);
        }
        return a;
    }

    protected long[] readLongArray0(InputContext ctx, int length) throws IOException {
        if (length == 0) {
            return LONG_0;
        }
        long[] a = new long[length];
        for (int i = 0; i < length; ++i) {
            a[i] = LongUtil.decodeVariableLong(ctx);
        }
        return a;
    }

    protected float[] readFloatArray0(InputContext ctx, int length) throws IOException {
        if (length == 0) {
            return FLOAT_0;
        }
        float[] a = new float[length];
        for (int i = 0; i < length; ++i) {
            a[i] = FloatUtil.decodeFloat(ctx);
        }
        return a;
    }

    protected double[] readDoubleArray0(InputContext ctx, int length) throws IOException {
        if (length == 0) {
            return DOUBLE_0;
        }
        double[] a = new double[length];
        for (int i = 0; i < length; ++i) {
            a[i] = DoubleUtil.decodeVariableDouble(ctx);
        }
        return a;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 5) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int indexOrLength = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 4 & 3);
        if ((parameterizedJmfType & 0x80) != 0) {
            ctx.indentPrintLn("<" + ctx.getObject(indexOrLength) + "@" + indexOrLength + ">");
        } else {
            int jmfComponentType = ctx.safeRead();
            int dimensions = (parameterizedJmfType & 0x40) == 0 ? 0 : ctx.safeRead();
            Class<?> componentType = this.jmfTypeToPrimitiveClass(jmfComponentType);
            if (dimensions == 0) {
                this.dumpPrimitiveArray0(ctx, componentType, jmfComponentType, indexOrLength);
            } else {
                this.dumpPrimitiveArray(ctx, componentType, jmfComponentType, indexOrLength, dimensions);
            }
        }
    }

    protected void dumpPrimitiveArray(DumpContext ctx, Class<?> componentType, int jmfComponentType, int length, int dimensions) throws IOException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        String v = this.newDumpPrimitiveArray(jmfComponentType, length, dimensions);
        int indexOfStoredObject = ctx.addToObjects(v);
        ctx.indentPrintLn(v + "@" + indexOfStoredObject + ": {");
        ctx.incrIndent(1);
        boolean dumpPrimitiveArray0 = --dimensions == 0;
        for (int index = 0; index < length; ++index) {
            int parameterizedJmfType = ctx.safeRead();
            int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
            if (jmfType == 120) {
                ctx.indentPrintLn("null");
                continue;
            }
            if (jmfType == 5) {
                int subLengthOrIndex = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 4 & 3);
                if ((parameterizedJmfType & 0x80) != 0) {
                    ctx.indentPrintLn("<" + ctx.getObject(subLengthOrIndex) + "@" + subLengthOrIndex + ">");
                    continue;
                }
                if (dumpPrimitiveArray0) {
                    this.dumpPrimitiveArray0(ctx, componentType, jmfComponentType, subLengthOrIndex);
                    continue;
                }
                this.dumpPrimitiveArray(ctx, componentType, jmfComponentType, subLengthOrIndex, dimensions);
                continue;
            }
            this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        ctx.incrIndent(-1);
        ctx.indentPrintLn("}");
    }

    protected void dumpPrimitiveArray0(DumpContext ctx, Class<?> componentType, int jmfComponentType, int length) throws IOException {
        String v = this.newDumpPrimitiveArray(jmfComponentType, length, 0);
        int indexOfStoredObject = ctx.addToObjects(v);
        ctx.indentPrint(v + "@" + indexOfStoredObject + ": {");
        switch (jmfComponentType) {
            case 56: {
                this.dumpBooleanArray0(ctx, length);
                break;
            }
            case 58: {
                this.dumpCharacterArray0(ctx, length);
                break;
            }
            case 123: {
                this.dumpByteArray0(ctx, length);
                break;
            }
            case 24: {
                this.dumpShortArray0(ctx, length);
                break;
            }
            case 8: {
                this.dumpIntegerArray0(ctx, length);
                break;
            }
            case 2: {
                this.dumpLongArray0(ctx, length);
                break;
            }
            case 125: {
                this.dumpFloatArray0(ctx, length);
                break;
            }
            case 0: {
                this.dumpDoubleArray0(ctx, length);
                break;
            }
            default: {
                throw new JMFEncodingException("Unsupported primitive type: " + jmfComponentType);
            }
        }
        ctx.noIndentPrintLn("}");
    }

    protected String newDumpPrimitiveArray(int jmfComponentType, int length, int dimensions) throws IOException {
        StringBuilder sb = new StringBuilder();
        switch (jmfComponentType) {
            case 56: {
                sb.append("boolean");
                break;
            }
            case 58: {
                sb.append("char");
                break;
            }
            case 123: {
                sb.append("byte");
                break;
            }
            case 24: {
                sb.append("short");
                break;
            }
            case 8: {
                sb.append("int");
                break;
            }
            case 2: {
                sb.append("long");
                break;
            }
            case 125: {
                sb.append("float");
                break;
            }
            case 0: {
                sb.append("double");
                break;
            }
            default: {
                throw new JMFEncodingException("Unsupported primitive type: " + jmfComponentType);
            }
        }
        sb.append('[').append(length).append(']');
        for (int i = 0; i < dimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    protected void dumpBooleanArray0(DumpContext ctx, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int nb = this.lengthOfBooleanArray(length);
        for (int i = 0; i < nb; ++i) {
            int index;
            int b = ctx.safeRead();
            for (int j = 0; j < 8 && (index = i * 8 + j) < length; ++j) {
                if (index > 0) {
                    ctx.print(", ");
                }
                ctx.print(String.valueOf((b & 128 >>> j) != 0));
            }
        }
    }

    protected void dumpCharacterArray0(DumpContext ctx, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ctx.print(", ");
            }
            ctx.print(String.valueOf((char)(ctx.safeRead() << 8 | ctx.safeRead())));
        }
    }

    protected void dumpByteArray0(DumpContext ctx, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ctx.print(", ");
            }
            ctx.print(String.valueOf((byte)ctx.safeRead()));
        }
    }

    protected void dumpShortArray0(DumpContext ctx, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ctx.print(", ");
            }
            ctx.print(String.valueOf((short)(ctx.safeRead() << 8) | ctx.safeRead()));
        }
    }

    protected void dumpIntegerArray0(DumpContext ctx, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ctx.print(", ");
            }
            ctx.print(String.valueOf(IntegerUtil.decodeVariableInteger(ctx)));
        }
    }

    protected void dumpLongArray0(DumpContext ctx, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ctx.print(", ");
            }
            ctx.print(String.valueOf(LongUtil.decodeVariableLong(ctx)));
        }
    }

    protected void dumpFloatArray0(DumpContext ctx, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ctx.print(", ");
            }
            ctx.print(String.valueOf(FloatUtil.decodeFloat(ctx)));
        }
    }

    protected void dumpDoubleArray0(DumpContext ctx, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ctx.print(", ");
            }
            ctx.print(String.valueOf(DoubleUtil.decodeVariableDouble(ctx)));
        }
    }

    protected int lengthOfBooleanArray(int nb) {
        return nb / 8 + (nb % 8 != 0 ? 1 : 0);
    }

    protected int primitiveClassToJmfType(Class<?> primitiveClass) throws JMFEncodingException {
        if (primitiveClass == Byte.TYPE) {
            return 123;
        }
        if (primitiveClass == Integer.TYPE) {
            return 8;
        }
        if (primitiveClass == Character.TYPE) {
            return 58;
        }
        if (primitiveClass == Double.TYPE) {
            return 0;
        }
        if (primitiveClass == Long.TYPE) {
            return 2;
        }
        if (primitiveClass == Boolean.TYPE) {
            return 56;
        }
        if (primitiveClass == Float.TYPE) {
            return 125;
        }
        if (primitiveClass == Short.TYPE) {
            return 24;
        }
        throw new JMFEncodingException("Not a primitive class: " + primitiveClass);
    }

    protected Class<?> jmfTypeToPrimitiveClass(int jmfType) throws JMFEncodingException {
        switch (jmfType) {
            case 56: {
                return Boolean.TYPE;
            }
            case 123: {
                return Byte.TYPE;
            }
            case 58: {
                return Character.TYPE;
            }
            case 24: {
                return Short.TYPE;
            }
            case 8: {
                return Integer.TYPE;
            }
            case 2: {
                return Long.TYPE;
            }
            case 125: {
                return Float.TYPE;
            }
            case 0: {
                return Double.TYPE;
            }
        }
        throw new JMFEncodingException("Not a primitive JMF type: " + jmfType);
    }
}

