/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class StreamUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResourceAsBytes(String path, ClassLoader loader) throws IOException {
        InputStream is;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if ((is = loader.getResourceAsStream(path)) == null) {
            throw new FileNotFoundException("Resource not found: " + path);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            int b = -1;
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
        }
        finally {
            is.close();
        }
        return baos.toByteArray();
    }

    public static ByteArrayInputStream getResourceAsStream(String path, ClassLoader loader) throws IOException {
        return new ByteArrayInputStream(StreamUtil.getResourceAsBytes(path, loader));
    }

    public static String getResourceAsString(String path, ClassLoader loader) throws IOException {
        return new String(StreamUtil.getResourceAsBytes(path, loader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamAsString(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            int b = -1;
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
        }
        finally {
            is.close();
        }
        return new String(baos.toByteArray());
    }
}

