/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.granite.client.messaging.AllInOneResponseListener;
import org.granite.client.messaging.ResponseListener;
import org.granite.client.messaging.ResponseListenerDispatcher;
import org.granite.client.messaging.channel.AbstractChannel;
import org.granite.client.messaging.channel.AsyncToken;
import org.granite.client.messaging.channel.Channel;
import org.granite.client.messaging.channel.ChannelStatusListener;
import org.granite.client.messaging.channel.ChannelStatusNotifier;
import org.granite.client.messaging.channel.Credentials;
import org.granite.client.messaging.channel.ImmediateFailureResponseMessageFuture;
import org.granite.client.messaging.channel.ResponseMessageFuture;
import org.granite.client.messaging.events.Event;
import org.granite.client.messaging.messages.MessageChain;
import org.granite.client.messaging.messages.RequestMessage;
import org.granite.client.messaging.messages.ResponseMessage;
import org.granite.client.messaging.messages.requests.DisconnectMessage;
import org.granite.client.messaging.messages.requests.LoginMessage;
import org.granite.client.messaging.messages.requests.LogoutMessage;
import org.granite.client.messaging.messages.requests.PingMessage;
import org.granite.client.messaging.messages.responses.FaultMessage;
import org.granite.client.messaging.messages.responses.ResultMessage;
import org.granite.client.messaging.transport.Transport;
import org.granite.client.messaging.transport.TransportFuture;
import org.granite.client.messaging.transport.TransportMessage;
import org.granite.client.messaging.transport.TransportStopListener;
import org.granite.logging.Logger;

public abstract class AbstractHTTPChannel
extends AbstractChannel<Transport>
implements TransportStopListener,
Runnable {
    private static final Logger log = Logger.getLogger(AbstractHTTPChannel.class);
    private final BlockingQueue<AsyncToken> tokensQueue = new LinkedBlockingQueue<AsyncToken>();
    private final ConcurrentMap<String, AsyncToken> tokensMap = new ConcurrentHashMap<String, AsyncToken>();
    private final AsyncToken stopToken = new AsyncToken(new DisconnectMessage());
    private final AtomicBoolean stopped = new AtomicBoolean(true);
    private AsyncToken disconnectToken = null;
    private Thread senderThread = null;
    private Semaphore connections;
    private Timer timer = null;
    private List<ChannelStatusListener> statusListeners = new ArrayList<ChannelStatusListener>();
    private volatile boolean pinged = false;
    private volatile boolean authenticated = false;
    private volatile boolean authenticating = false;
    protected volatile int maxConcurrentRequests;
    protected volatile long defaultTimeToLive = DEFAULT_TIME_TO_LIVE;
    private ChannelStatusListener statusListener = new ChannelStatusListener(){

        @Override
        public void fault(Channel channel, FaultMessage faultMessage) {
        }

        @Override
        public void pingedChanged(Channel channel, boolean pinged) {
            if (channel == AbstractHTTPChannel.this) {
                return;
            }
            AbstractHTTPChannel.this.pinged = pinged;
        }

        @Override
        public void authenticatedChanged(Channel channel, boolean authenticated) {
            if (channel == AbstractHTTPChannel.this) {
                return;
            }
            AbstractHTTPChannel.this.authenticating = false;
            AbstractHTTPChannel.this.authenticated = authenticated;
        }
    };

    public AbstractHTTPChannel(Transport transport, String id, URI uri, int maxConcurrentRequests) {
        super(transport, id, uri);
        if (maxConcurrentRequests < 1) {
            throw new IllegalArgumentException("maxConcurrentRequests must be greater or equal to 1");
        }
        this.maxConcurrentRequests = maxConcurrentRequests;
    }

    protected abstract TransportMessage createTransportMessage(AsyncToken var1) throws UnsupportedEncodingException;

    protected abstract ResponseMessage decodeResponse(InputStream var1) throws IOException;

    protected boolean schedule(TimerTask timerTask, long delay) {
        if (this.timer != null) {
            this.timer.schedule(timerTask, delay);
            return true;
        }
        return false;
    }

    @Override
    public long getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    @Override
    public void setDefaultTimeToLive(long defaultTimeToLive) {
        this.defaultTimeToLive = defaultTimeToLive;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    @Override
    public void onStop(Transport transport) {
        this.stop();
    }

    @Override
    public synchronized boolean start() {
        if (this.senderThread != null) {
            return true;
        }
        this.tokensQueue.clear();
        this.tokensMap.clear();
        this.disconnectToken = null;
        this.stopped.set(false);
        log.info("Starting channel %s...", this.id);
        this.senderThread = new Thread((Runnable)this, this.id + "_sender");
        try {
            this.timer = new Timer(this.id + "_timer", true);
            this.connections = new Semaphore(this.maxConcurrentRequests);
            this.senderThread.start();
            this.transport.addStopListener(this);
            log.info("Channel %s started.", this.id);
        }
        catch (Exception e) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.connections = null;
            this.senderThread = null;
            log.error(e, "Channel %s failed to start.", this.id);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.senderThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean stop() {
        if (this.senderThread == null) {
            return false;
        }
        log.info("Stopping channel %s...", this.id);
        if (this.timer != null) {
            try {
                this.timer.cancel();
            }
            catch (Exception e) {
                log.error(e, "Channel %s timer failed to stop.", this.id);
            }
            finally {
                this.timer = null;
            }
        }
        this.internalStop();
        log.debug("Interrupting thread %s", this.id);
        this.connections = null;
        this.tokensMap.clear();
        this.tokensQueue.clear();
        this.disconnectToken = null;
        this.stopped.set(true);
        this.tokensQueue.add(this.stopToken);
        Thread thread = this.senderThread;
        this.senderThread = null;
        thread.interrupt();
        this.pinged = false;
        this.clientId = null;
        this.authenticated = false;
        return true;
    }

    protected void internalStop() {
    }

    protected LoginMessage authenticate(AsyncToken dependentToken) {
        if (this.authenticating || this.authenticated) {
            return null;
        }
        Credentials credentials = this.credentials;
        if (credentials == null) {
            return null;
        }
        LoginMessage loginMessage = new LoginMessage(this.clientId, credentials);
        if (dependentToken != null) {
            log.debug("Channel %s blocking authentication %s clientId %s", this.id, loginMessage.getId(), this.clientId);
            ResultMessage result = this.sendBlockingToken(loginMessage, dependentToken);
            if (result == null) {
                return loginMessage;
            }
            this.authenticated = true;
            this.authenticating = false;
        } else {
            log.debug("Channel %s non blocking authentication %s clientId %s", this.id, loginMessage.getId(), this.clientId);
            this.send(loginMessage, new ResponseListener[0]);
            this.authenticating = true;
        }
        return loginMessage;
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                AsyncToken token;
                if (this.stopped.get() || (token = this.tokensQueue.take()) == this.stopToken) break;
                if (token.isDone()) continue;
                if (token.isDisconnectRequest()) {
                    this.sendToken(token);
                    continue;
                }
                if (!this.pinged) {
                    PingMessage pingMessage = new PingMessage(this.clientId);
                    log.debug("Channel %s send ping %s with clientId %s", this.id, pingMessage.getId(), this.clientId);
                    ResultMessage result = this.sendBlockingToken(pingMessage, token);
                    if (result == null) continue;
                    this.clientId = result.getClientId();
                    log.debug("Channel %s pinged clientId %s", this.id, this.clientId);
                    this.pinged = true;
                }
                this.authenticate(token);
                this.sendToken(token);
            }
            catch (InterruptedException e) {
                log.info("Channel %s stopped.", this.id);
                break;
            }
            catch (Exception e) {
                log.error(e, "Channel %s got an unexpected exception.", this.id);
            }
        }
    }

    private ResultMessage sendBlockingToken(RequestMessage request, AsyncToken dependentToken) {
        request.setTimestamp(dependentToken.getRequest().getTimestamp());
        request.setTimeToLive(dependentToken.getRequest().getTimeToLive());
        AsyncToken blockingToken = new AsyncToken(request);
        try {
            this.timer.schedule((TimerTask)blockingToken, blockingToken.getRequest().getRemainingTimeToLive());
        }
        catch (IllegalArgumentException e) {
            dependentToken.dispatchTimeout(System.currentTimeMillis());
            return null;
        }
        catch (Exception e) {
            dependentToken.dispatchFailure(e);
            return null;
        }
        try {
            if (!this.sendToken(blockingToken)) {
                return null;
            }
        }
        catch (Exception e) {
            dependentToken.dispatchFailure(e);
            return null;
        }
        try {
            FaultMessage faultMessage;
            ResponseMessage response = blockingToken.get();
            if (response instanceof ResultMessage) {
                return (ResultMessage)response;
            }
            if (response instanceof FaultMessage) {
                faultMessage = (FaultMessage)response.copy(dependentToken.getRequest().getId());
                if (dependentToken.getRequest() instanceof MessageChain) {
                    ResponseMessage nextResponse = faultMessage;
                    for (Object nextRequest = ((MessageChain)((Object)dependentToken.getRequest())).getNext(); nextRequest != null; nextRequest = nextRequest.getNext()) {
                        nextResponse.setNext(response.copy(nextRequest.getId()));
                        nextResponse = (ResponseMessage)nextResponse.getNext();
                    }
                }
            } else {
                throw new RuntimeException("Unknown response message type: " + response);
            }
            dependentToken.dispatchFault(faultMessage);
        }
        catch (InterruptedException e) {
            dependentToken.dispatchFailure(e);
        }
        catch (TimeoutException e) {
            dependentToken.dispatchTimeout(System.currentTimeMillis());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Exception) {
                dependentToken.dispatchFailure((Exception)e.getCause());
            } else {
                dependentToken.dispatchFailure(e);
            }
        }
        catch (Exception e) {
            dependentToken.dispatchFailure(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendToken(AsyncToken token) {
        boolean releaseConnections = false;
        try {
            if (!this.connections.tryAcquire(token.getRequest().getRemainingTimeToLive(), TimeUnit.MILLISECONDS)) {
                token.dispatchTimeout(System.currentTimeMillis());
                boolean bl = false;
                return bl;
            }
            releaseConnections = true;
            if (token.isDone()) {
                boolean bl = false;
                return bl;
            }
            token.getRequest().setClientId(this.clientId);
            if (token.getRequest() instanceof DisconnectMessage) {
                this.disconnectToken = token;
            } else if (this.tokensMap.putIfAbsent(token.getId(), token) != null) {
                throw new RuntimeException("MessageId isn't unique: " + token.getId());
            }
            TransportFuture transportFuture = this.transport.send(this, this.createTransportMessage(token));
            ChannelResponseListener channelListener = new ChannelResponseListener(token.getId(), this.tokensMap, transportFuture, this.connections);
            Event tokenEvent = token.setChannelListener(channelListener);
            if (tokenEvent != null) {
                ResponseListenerDispatcher.dispatch(channelListener, tokenEvent);
            }
            releaseConnections = false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.tokensMap.remove(token.getId());
            token.dispatchFailure(e);
            if (this.timer != null) {
                this.timer.purge();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (releaseConnections && this.connections != null) {
                this.connections.release();
            }
        }
    }

    protected RequestMessage getRequest(String id) {
        AsyncToken token = (AsyncToken)this.tokensMap.get(id);
        return token != null ? token.getRequest() : null;
    }

    @Override
    public ResponseMessageFuture send(RequestMessage request, ResponseListener ... listeners) {
        if (request == null) {
            throw new NullPointerException("request cannot be null");
        }
        if (!this.start()) {
            throw new RuntimeException("Channel not started");
        }
        AsyncToken token = new AsyncToken(request, listeners);
        request.setTimestamp(System.currentTimeMillis());
        if (request.getTimeToLive() <= 0L) {
            request.setTimeToLive(this.defaultTimeToLive);
        }
        try {
            this.timer.schedule((TimerTask)token, request.getRemainingTimeToLive());
            this.tokensQueue.add(token);
        }
        catch (Exception e) {
            log.error(e, "Could not add token to queue: %s", token);
            token.dispatchFailure(e);
            return new ImmediateFailureResponseMessageFuture(e);
        }
        return token;
    }

    @Override
    public ResponseMessageFuture logout(ResponseListener ... listeners) {
        return this.logout(true, listeners);
    }

    @Override
    public ResponseMessageFuture logout(boolean sendLogout, ResponseListener ... listeners) {
        this.credentials = null;
        this.authenticated = false;
        if (sendLogout) {
            return this.send(new LogoutMessage(), listeners);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onMessage(TransportMessage message, InputStream is) {
        AsyncToken token;
        try {
            ResponseMessage response = this.decodeResponse(is);
            if (response == null) {
                return;
            }
            token = (AsyncToken)this.tokensMap.remove(response.getCorrelationId());
            if (token == null) {
                log.warn("Unknown correlation id: %s", response.getCorrelationId());
                return;
            }
            switch (response.getType()) {
                case RESULT: {
                    token.dispatchResult((ResultMessage)response);
                    return;
                }
                case FAULT: {
                    FaultMessage faultMessage = (FaultMessage)response;
                    if (this.isAuthenticated() && (faultMessage.getCode() == FaultMessage.Code.NOT_LOGGED_IN || faultMessage.getCode() == FaultMessage.Code.SESSION_EXPIRED)) {
                        this.authenticated = false;
                        this.credentials = null;
                    }
                    token.dispatchFault((FaultMessage)response);
                    return;
                }
                default: {
                    token.dispatchFailure(new RuntimeException("Unknown message type: " + response));
                    return;
                }
            }
        }
        catch (Exception e) {
            log.error(e, "Could not deserialize or dispatch incoming messages", new Object[0]);
            AsyncToken asyncToken = token = message != null ? (AsyncToken)this.tokensMap.remove(message.getId()) : null;
            if (token == null) return;
            token.dispatchFailure(e);
            return;
        }
        finally {
            if (this.timer != null) {
                this.timer.purge();
            }
        }
    }

    @Override
    public void onDisconnect() {
        log.info("Disconnecting channel %s", this.clientId);
        this.tokensMap.clear();
        this.tokensQueue.clear();
        if (this.timer != null) {
            this.timer.purge();
        }
        if (this.disconnectToken != null) {
            ResultMessage resultMessage = new ResultMessage(this.clientId, this.disconnectToken.getRequest().getId(), true);
            this.disconnectToken.dispatchResult(resultMessage);
            this.disconnectToken = null;
        }
        this.clientId = null;
        this.pinged = false;
        this.authenticating = false;
        this.authenticated = false;
    }

    @Override
    public void onError(TransportMessage message, Exception e) {
        if (message == null) {
            return;
        }
        AsyncToken token = (AsyncToken)this.tokensMap.remove(message.getId());
        if (token == null) {
            return;
        }
        token.dispatchFailure(e);
        if (this.timer != null) {
            this.timer.purge();
        }
    }

    @Override
    public void onCancelled(TransportMessage message) {
        AsyncToken token = (AsyncToken)this.tokensMap.remove(message.getId());
        if (token == null) {
            return;
        }
        token.dispatchCancelled();
        if (this.timer != null) {
            this.timer.purge();
        }
    }

    @Override
    public void addListener(ChannelStatusListener listener) {
        this.statusListeners.add(listener);
    }

    @Override
    public void removeListener(ChannelStatusListener listener) {
        this.statusListeners.remove(listener);
    }

    protected void setPinged(boolean pinged) {
        if (this.pinged == pinged) {
            return;
        }
        this.pinged = pinged;
        for (ChannelStatusListener listener : this.statusListeners) {
            listener.pingedChanged(this, pinged);
        }
    }

    protected void setAuthenticated(boolean authenticated) {
        if (!this.authenticating && this.authenticated == authenticated) {
            return;
        }
        this.authenticating = false;
        this.authenticated = authenticated;
        for (ChannelStatusListener listener : this.statusListeners) {
            listener.authenticatedChanged(this, authenticated);
        }
    }

    protected void dispatchFault(FaultMessage faultMessage) {
        for (ChannelStatusListener listener : this.statusListeners) {
            listener.fault(this, faultMessage);
        }
    }

    @Override
    public void bindStatus(ChannelStatusNotifier notifier) {
        notifier.addListener(this.statusListener);
    }

    @Override
    public void unbindStatus(ChannelStatusNotifier notifier) {
        notifier.removeListener(this.statusListener);
    }

    private static class ChannelResponseListener
    extends AllInOneResponseListener {
        private final String tokenId;
        private final ConcurrentMap<String, AsyncToken> tokensMap;
        private final TransportFuture transportFuture;
        private final Semaphore connections;

        public ChannelResponseListener(String tokenId, ConcurrentMap<String, AsyncToken> tokensMap, TransportFuture transportFuture, Semaphore connections) {
            this.tokenId = tokenId;
            this.tokensMap = tokensMap;
            this.transportFuture = transportFuture;
            this.connections = connections;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(Event event) {
            try {
                this.tokensMap.remove(this.tokenId);
                if ((event.getType() == Event.Type.TIMEOUT || event.getType() == Event.Type.CANCELLED) && this.transportFuture != null) {
                    try {
                        this.transportFuture.cancel();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
            }
            finally {
                if (this.connections != null) {
                    this.connections.release();
                }
            }
        }
    }
}

