/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel;

import flex.messaging.messages.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.granite.client.messaging.channel.AbstractChannelFactory;
import org.granite.client.messaging.channel.RemotingChannel;
import org.granite.client.messaging.channel.amf.JMFRemotingChannel;
import org.granite.client.messaging.codec.JMFAMF0MessagingCodec;
import org.granite.client.messaging.codec.JMFAMF3MessagingCodec;
import org.granite.client.messaging.codec.MessagingCodec;
import org.granite.client.messaging.jmf.ClientSharedContext;
import org.granite.client.messaging.jmf.DefaultClientSharedContext;
import org.granite.client.messaging.jmf.ext.ClientEntityCodec;
import org.granite.client.messaging.transport.Transport;
import org.granite.client.platform.Platform;
import org.granite.messaging.amf.AMF0Message;
import org.granite.messaging.jmf.DefaultCodecRegistry;
import org.granite.messaging.jmf.codec.ExtendedObjectCodec;
import org.granite.messaging.reflect.Reflection;
import org.granite.util.ContentType;
import org.granite.util.JMFAMFUtil;

public class JMFChannelFactory
extends AbstractChannelFactory {
    private ClientSharedContext sharedContext = null;
    private List<ExtendedObjectCodec> extendedCodecs = null;
    private List<String> defaultStoredStrings = null;
    private Reflection reflection = null;

    public JMFChannelFactory() {
        super(ContentType.JMF_AMF);
    }

    public JMFChannelFactory(Object context) {
        super(ContentType.JMF_AMF, context);
    }

    public JMFChannelFactory(Object context, ClientSharedContext sharedContext, Transport remotingTransport, Transport messagingTransport) {
        super(ContentType.JMF_AMF, context, remotingTransport, messagingTransport);
        this.sharedContext = sharedContext;
    }

    public ClientSharedContext getSharedContext() {
        return this.sharedContext;
    }

    public void setSharedContext(ClientSharedContext sharedContext) {
        this.sharedContext = sharedContext;
    }

    public List<ExtendedObjectCodec> getExtendedCodecs() {
        return this.extendedCodecs;
    }

    public void setExtendedCodecs(List<ExtendedObjectCodec> extendedCodecs) {
        this.extendedCodecs = extendedCodecs;
    }

    public List<String> getDefaultStoredStrings() {
        return this.defaultStoredStrings;
    }

    public void setDefaultStoredStrings(List<String> defaultStoredStrings) {
        this.defaultStoredStrings = defaultStoredStrings;
    }

    public Reflection getReflection() {
        return this.reflection;
    }

    public void setReflection(Reflection reflection) {
        this.reflection = reflection;
    }

    @Override
    public void start() {
        super.start();
        if (this.sharedContext == null) {
            this.extendedCodecs = this.extendedCodecs != null ? this.extendedCodecs : new ArrayList<ClientEntityCodec>(Arrays.asList(new ClientEntityCodec()));
            this.defaultStoredStrings = this.defaultStoredStrings != null ? this.defaultStoredStrings : new ArrayList<String>(JMFAMFUtil.AMF_DEFAULT_STORED_STRINGS);
            this.reflection = this.reflection != null ? this.reflection : Platform.reflection();
            this.sharedContext = new DefaultClientSharedContext(new DefaultCodecRegistry(this.extendedCodecs), this.defaultStoredStrings, this.reflection, this.aliasRegistry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean stopTransports) {
        try {
            super.stop(stopTransports);
        }
        finally {
            this.sharedContext = null;
            this.extendedCodecs = null;
            this.defaultStoredStrings = null;
            this.reflection = null;
        }
    }

    @Override
    protected Class<? extends RemotingChannel> getRemotingChannelClass() {
        return JMFRemotingChannel.class;
    }

    @Override
    protected <M> MessagingCodec<M> newMessagingCodec(Class<M> messageClass) {
        if (messageClass == Message[].class) {
            return new JMFAMF3MessagingCodec(this.getSharedContext());
        }
        if (messageClass == AMF0Message.class) {
            return new JMFAMF0MessagingCodec(this.getSharedContext());
        }
        throw new IllegalArgumentException("Unknown message class " + messageClass);
    }
}

