/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.granite.client.messaging.channel.Credentials;
import org.granite.util.Base64;

public final class UsernamePasswordCredentials
implements Credentials {
    private final String username;
    private final String password;
    private final Charset charset;

    public UsernamePasswordCredentials(String username, String password) {
        this(username, password, null);
    }

    public UsernamePasswordCredentials(String username, String password, Charset charset) {
        this.username = username;
        this.password = password;
        this.charset = charset != null ? charset : Charset.defaultCharset();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String encodeBase64() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (this.username != null) {
            if (this.username.indexOf(58) != -1) {
                throw new UnsupportedEncodingException("Username cannot contain ':' characters: " + this.username);
            }
            sb.append(this.username);
        }
        sb.append(':');
        if (this.username != null) {
            sb.append(this.password);
        }
        return Base64.encodeToString(sb.toString().getBytes(this.charset.name()), false);
    }

    public String toString() {
        return this.getClass().getName() + " {username=***, password=***, charset=" + this.charset + "}";
    }
}

