/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.granite.client.configuration.Configuration;
import org.granite.client.messaging.codec.MessagingCodec;
import org.granite.context.GraniteContext;
import org.granite.context.SimpleGraniteContext;
import org.granite.messaging.amf.AMF0Message;
import org.granite.messaging.amf.io.AMF0Deserializer;
import org.granite.messaging.amf.io.AMF0Serializer;
import org.granite.util.ContentType;

public class AMF0MessagingCodec
implements MessagingCodec<AMF0Message> {
    private final Configuration config;

    public AMF0MessagingCodec(Configuration config) {
        this.config = config;
    }

    @Override
    public MessagingCodec.ClientType getClientType() {
        return this.config.getClientType();
    }

    @Override
    public String getContentType() {
        return ContentType.AMF.mimeType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(AMF0Message message, OutputStream output) throws IOException {
        SimpleGraniteContext.createThreadInstance(this.config.getGraniteConfig(), this.config.getServicesConfig(), new HashMap<String, Object>(0), this.getClientType().toString());
        try {
            AMF0Serializer serializer = new AMF0Serializer(output);
            serializer.serializeMessage(message);
        }
        finally {
            GraniteContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AMF0Message decode(InputStream input) throws IOException {
        SimpleGraniteContext.createThreadInstance(this.config.getGraniteConfig(), this.config.getServicesConfig(), new HashMap<String, Object>(0), this.getClientType().toString());
        try {
            AMF0Deserializer deserializer = new AMF0Deserializer(input);
            AMF0Message aMF0Message = deserializer.getAMFMessage();
            return aMF0Message;
        }
        finally {
            GraniteContext.release();
        }
    }
}

