/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.codec;

import flex.messaging.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.granite.client.messaging.codec.MessagingCodec;
import org.granite.client.messaging.jmf.ClientSharedContext;
import org.granite.messaging.jmf.JMFDeserializer;
import org.granite.messaging.jmf.JMFSerializer;
import org.granite.util.ContentType;

public class JMFAMF3MessagingCodec
implements MessagingCodec<Message[]> {
    private final ClientSharedContext sharedContext;

    public JMFAMF3MessagingCodec(ClientSharedContext sharedContext) {
        this.sharedContext = sharedContext;
    }

    @Override
    public MessagingCodec.ClientType getClientType() {
        return MessagingCodec.ClientType.JAVA;
    }

    @Override
    public String getContentType() {
        return ContentType.JMF_AMF.mimeType();
    }

    @Override
    public void encode(Message[] messages, OutputStream output) throws IOException {
        JMFSerializer serializer = new JMFSerializer(output, this.sharedContext);
        serializer.writeObject(messages);
    }

    @Override
    public Message[] decode(InputStream input) throws IOException {
        JMFDeserializer deserializer = new JMFDeserializer(input, this.sharedContext);
        Message[] messages = null;
        try {
            messages = (Message[])deserializer.readObject();
            if (messages != null) {
                for (Message message : messages) {
                    if (message == null || !Boolean.TRUE.equals(message.getHeader("GDS_BYTEARRAY_BODY"))) continue;
                    byte[] body = (byte[])message.getBody();
                    deserializer = new JMFDeserializer(new ByteArrayInputStream(body), this.sharedContext);
                    message.setBody(deserializer.readObject());
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        return messages != null ? messages : new Message[]{};
    }
}

