/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.messages.requests;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.granite.client.messaging.messages.Message;
import org.granite.client.messaging.messages.MessageChain;
import org.granite.client.messaging.messages.requests.AbstractRequestMessage;

public final class InvocationMessage
extends AbstractRequestMessage
implements MessageChain<InvocationMessage> {
    private static final long serialVersionUID = 1L;
    private String serviceId = null;
    private String method = null;
    private Object[] parameters = null;
    private InvocationMessage next = null;

    public InvocationMessage() {
    }

    public InvocationMessage(String serviceId, String method, Object[] parameters) {
        this(null, serviceId, method, parameters);
    }

    public InvocationMessage(String clientId, String serviceId, String method, Object[] parameters) {
        super(clientId);
        this.serviceId = serviceId;
        this.method = method;
        this.parameters = parameters;
    }

    public InvocationMessage(String id, String clientId, long timestamp, long timeToLive, Map<String, Object> headers, String serviceId, String method, Object[] parameters) {
        super(id, clientId, timestamp, timeToLive, headers);
        this.serviceId = serviceId;
        this.method = method;
        this.parameters = parameters;
    }

    @Override
    public Message.Type getType() {
        return Message.Type.INVOCATION;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    @Override
    public void setNext(InvocationMessage next) {
        for (InvocationMessage n = next; n != null; n = n.getNext()) {
            if (n != this) continue;
            throw new RuntimeException("Circular chaining to this: " + next);
        }
        this.next = next;
    }

    @Override
    public InvocationMessage getNext() {
        return this.next;
    }

    @Override
    public Iterator<InvocationMessage> iterator() {
        final InvocationMessage first = this;
        return new Iterator<InvocationMessage>(){
            private InvocationMessage current;
            {
                this.current = first;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public InvocationMessage next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                InvocationMessage c = this.current;
                this.current = this.current.getNext();
                return c;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public InvocationMessage copy() {
        InvocationMessage message = new InvocationMessage();
        this.copy(message);
        message.serviceId = this.serviceId;
        message.method = this.method;
        message.parameters = this.parameters;
        return message;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.serviceId = in.readUTF();
        this.method = in.readUTF();
        this.parameters = (Object[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.serviceId);
        out.writeUTF(this.method);
        out.writeObject(this.parameters);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return super.toString(sb).append("\n    serviceId=").append(this.serviceId).append("\n    method=").append(this.method).append("\n    parameters=").append(this.parameters == null ? null : Arrays.toString(this.parameters));
    }
}

