/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.transport;

import org.granite.client.messaging.transport.TransportException;
import org.granite.logging.Logger;

public interface TransportStatusHandler {
    public void handleIO(boolean var1);

    public void handleException(TransportException var1);

    public static class LogEngineStatusHandler
    implements TransportStatusHandler {
        private static final Logger log = Logger.getLogger(LogEngineStatusHandler.class);

        @Override
        public void handleIO(boolean active) {
            log.debug(active ? "Starting IO" : "IO completed", new Object[0]);
        }

        @Override
        public void handleException(TransportException e) {
            log.error(e, "Engine failed", new Object[0]);
        }
    }

    public static class NoopEngineStatusHandler
    implements TransportStatusHandler {
        @Override
        public void handleIO(boolean active) {
        }

        @Override
        public void handleException(TransportException e) {
        }
    }
}

