/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.transport.jetty9;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.granite.client.messaging.channel.Channel;
import org.granite.client.messaging.transport.TransportException;
import org.granite.client.messaging.transport.TransportMessage;
import org.granite.client.messaging.transport.websocket.AbstractWebSocketTransport;
import org.granite.logging.Logger;

public class JettyWebSocketTransport
extends AbstractWebSocketTransport<Session> {
    private static final Logger log = Logger.getLogger(JettyWebSocketTransport.class);
    private WebSocketClient webSocketClient = null;
    private SslContextFactory sslContextFactory = null;

    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    @Override
    public synchronized boolean start() {
        if (this.isStarted()) {
            return true;
        }
        log.info("Starting Jetty 9 WebSocketClient transport...", new Object[0]);
        try {
            if (this.sslContextFactory == null) {
                this.webSocketClient = new WebSocketClient();
            } else {
                Constructor c = WebSocketClient.class.getConstructor(SslContextFactory.class);
                this.webSocketClient = (WebSocketClient)c.newInstance(this.sslContextFactory);
            }
            this.webSocketClient.setMaxIdleTimeout((long)this.getMaxIdleTime());
            this.webSocketClient.setMaxTextMessageBufferSize(1024);
            this.webSocketClient.setMaxBinaryMessageBufferSize(this.getMaxMessageSize());
            this.webSocketClient.setCookieStore((CookieStore)new HttpCookieStore());
            this.webSocketClient.start();
            log.info("Jetty 9 WebSocketClient transport started.", new Object[0]);
            return true;
        }
        catch (Exception e) {
            this.webSocketClient = null;
            this.getStatusHandler().handleException(new TransportException("Could not start Jetty 9 WebSocketFactory", e));
            log.error(e, "Jetty 9 WebSocketClient transport failed to start.", new Object[0]);
            return false;
        }
    }

    @Override
    public synchronized boolean isStarted() {
        return this.webSocketClient != null;
    }

    @Override
    public void connect(Channel channel, TransportMessage transportMessage) {
        try {
            String clientId;
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            request.setRequestURI(channel.getUri());
            String protocol = "org.granite.gravity." + transportMessage.getContentType().substring("application/x-".length());
            request.setSubProtocols(new String[]{protocol});
            if (transportMessage.getSessionId() != null) {
                this.webSocketClient.getCookieStore().add(channel.getUri(), new HttpCookie("JSESSIONID", transportMessage.getSessionId()));
            }
            request.setCookiesFrom(this.webSocketClient.getCookieStore());
            request.setHeader("connectId", transportMessage.getId());
            request.setHeader("GDSClientType", transportMessage.getClientType().toString());
            String string = clientId = transportMessage.getClientId() != null ? transportMessage.getClientId() : channel.getClientId();
            if (clientId != null) {
                request.setHeader("GDSClientId", clientId);
            }
            log.info("Connecting to websocket %s protocol %s sessionId %s clientId %s", channel.getUri(), protocol, transportMessage.getSessionId(), clientId);
            this.webSocketClient.connect((Object)new WebSocketHandler(channel), channel.getUri(), request);
        }
        catch (Exception e) {
            log.error(e, "Could not connect to uri %s", channel.getUri());
            this.getStatusHandler().handleException(new TransportException("Could not connect to uri " + channel.getUri(), e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.webSocketClient == null) {
            return;
        }
        log.info("Stopping Jetty 9 WebSocketClient transport...", new Object[0]);
        this.setStopping(true);
        super.stop();
        try {
            this.webSocketClient.stop();
        }
        catch (Exception e) {
            this.getStatusHandler().handleException(new TransportException("Could not stop Jetty 9 WebSocketFactory", e));
            log.error(e, "Jetty 9 WebSocketClient failed to stop properly.", new Object[0]);
        }
        finally {
            this.webSocketClient.destroy();
            this.webSocketClient = null;
            this.setStopping(false);
        }
        log.info("Jetty 9 WebSocketClient transport stopped.", new Object[0]);
    }

    @Override
    protected AbstractWebSocketTransport.TransportData<Session> newTransportData() {
        return new Jetty9TransportData();
    }

    private class WebSocketHandler
    implements WebSocketListener {
        private final Channel channel;

        public WebSocketHandler(Channel channel) {
            this.channel = channel;
        }

        public void onWebSocketConnect(Session session) {
            JettyWebSocketTransport.this.onConnect(this.channel, session);
        }

        public void onWebSocketBinary(byte[] data, int offset, int length) {
            JettyWebSocketTransport.this.onBinaryMessage(this.channel, data, offset, length);
        }

        public void onWebSocketClose(int closeCode, String message) {
            JettyWebSocketTransport.this.onClose(this.channel, closeCode, message);
        }

        public void onWebSocketError(Throwable throwable) {
            JettyWebSocketTransport.this.onError(this.channel, throwable);
        }

        public void onWebSocketText(String s) {
            log.warn("Websocket text message not supported", new Object[0]);
        }
    }

    public static class Jetty9TransportData
    extends AbstractWebSocketTransport.TransportData<Session> {
        private Session session = null;

        @Override
        public void connect(Session session) {
            this.session = session;
        }

        @Override
        public boolean isConnected() {
            return this.session != null;
        }

        @Override
        public void disconnect() {
            this.session = null;
        }

        @Override
        public void sendBytes(byte[] data) throws IOException {
            this.session.getRemote().sendBytes(ByteBuffer.wrap(data));
        }
    }
}

