/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.transport.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.granite.client.messaging.channel.Channel;
import org.granite.client.messaging.transport.TransportException;
import org.granite.client.messaging.transport.TransportMessage;
import org.granite.client.messaging.transport.websocket.AbstractWebSocketTransport;
import org.granite.logging.Logger;

public abstract class WebSocketTransport
extends AbstractWebSocketTransport<Session> {
    private static final Logger log = Logger.getLogger(WebSocketTransport.class);
    private WebSocketContainer webSocketContainer;
    private Map<String, Object> userProperties = null;

    public void setUserProperties(Map<String, Object> userProperties) {
        this.userProperties = userProperties;
    }

    @Override
    public synchronized boolean start() {
        if (this.isStarted()) {
            return true;
        }
        log.info("Starting WebSocket transport...", new Object[0]);
        try {
            this.webSocketContainer = this.createContainer();
            this.webSocketContainer.setDefaultMaxBinaryMessageBufferSize(this.getMaxMessageSize());
            log.info("WebSocket transport started.", new Object[0]);
            return true;
        }
        catch (Exception e) {
            this.webSocketContainer = null;
            this.getStatusHandler().handleException(new TransportException("Could not start WebSocket Endpoint", e));
            log.error(e, "WebSocket transport failed to start.", new Object[0]);
            return false;
        }
    }

    protected abstract WebSocketContainer createContainer();

    protected abstract void closeContainer(WebSocketContainer var1);

    @Override
    public synchronized boolean isStarted() {
        return this.webSocketContainer != null;
    }

    @Override
    public void connect(Channel channel, TransportMessage transportMessage) {
        try {
            log.info("Connecting to websocket %s sessionId %s", channel.getUri(), transportMessage.getSessionId());
            this.webSocketContainer.connectToServer((Endpoint)new GravityWebSocketEndpoint(channel), (ClientEndpointConfig)new GravityWebSocketEndpointConfig(channel, transportMessage), channel.getUri());
        }
        catch (Exception e) {
            log.error(e, "Could not connect to uri %s", channel.getUri());
            this.getStatusHandler().handleException(new TransportException("Could not connect to uri " + channel.getUri(), e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.webSocketContainer == null) {
            return;
        }
        log.info("Stopping WebSocket transport...", new Object[0]);
        this.setStopping(true);
        super.stop();
        try {
            this.closeContainer(this.webSocketContainer);
        }
        catch (Exception e) {
            this.getStatusHandler().handleException(new TransportException("Could not stop WebSocket", e));
            log.error(e, "WebSocket failed to stop properly.", new Object[0]);
        }
        finally {
            this.webSocketContainer = null;
            this.setStopping(false);
        }
        log.info("WebSocket transport stopped.", new Object[0]);
    }

    @Override
    protected AbstractWebSocketTransport.TransportData<Session> newTransportData() {
        return new WebSocketTransportData();
    }

    private class WebSocketTransportData
    extends AbstractWebSocketTransport.TransportData<Session> {
        private Session session = null;

        private WebSocketTransportData() {
        }

        @Override
        public void connect(Session session) {
            this.session = session;
        }

        @Override
        public boolean isConnected() {
            return this.session != null;
        }

        @Override
        public void disconnect() {
            this.session = null;
        }

        @Override
        public void sendBytes(byte[] data) throws IOException {
            this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(data));
        }
    }

    public class GravityWebSocketEndpoint
    extends Endpoint
    implements MessageHandler.Whole<byte[]> {
        private Channel channel;

        public GravityWebSocketEndpoint(Channel channel) {
            this.channel = channel;
        }

        public void onOpen(Session session, EndpointConfig endpointConfig) {
            session.addMessageHandler((MessageHandler)this);
            WebSocketTransport.this.onConnect(this.channel, session);
        }

        public void onMessage(byte[] data) {
            WebSocketTransport.this.onBinaryMessage(this.channel, data, 0, data.length);
        }

        public void onClose(Session session, CloseReason closeReason) {
            WebSocketTransport.this.onClose(this.channel, closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
        }

        public void onError(Session session, Throwable error) {
            WebSocketTransport.this.onError(this.channel, error);
        }
    }

    public class GravityWebSocketEndpointConfig
    implements ClientEndpointConfig {
        private final List<String> protocols;
        private final Channel channel;
        private final TransportMessage transportMessage;
        private final Map<String, Object> userProperties = new ConcurrentHashMap<String, Object>();

        public GravityWebSocketEndpointConfig(Channel channel, TransportMessage transportMessage) {
            String protocol = "org.granite.gravity." + transportMessage.getContentType().substring("application/x-".length());
            this.protocols = Collections.singletonList(protocol);
            this.channel = channel;
            this.transportMessage = transportMessage;
            if (WebSocketTransport.this.userProperties != null) {
                this.userProperties.putAll(WebSocketTransport.this.userProperties);
            }
        }

        public ClientEndpointConfig.Configurator getConfigurator() {
            return new GravityWebSocketConfigurator();
        }

        public List<String> getPreferredSubprotocols() {
            return this.protocols;
        }

        public List<Extension> getExtensions() {
            return Collections.emptyList();
        }

        public List<Class<? extends Encoder>> getEncoders() {
            return Collections.emptyList();
        }

        public List<Class<? extends Decoder>> getDecoders() {
            return Collections.emptyList();
        }

        public Map<String, Object> getUserProperties() {
            return this.userProperties;
        }

        private class GravityWebSocketConfigurator
        extends ClientEndpointConfig.Configurator {
            private GravityWebSocketConfigurator() {
            }

            public void beforeRequest(Map<String, List<String>> headers) {
                String clientId;
                if (GravityWebSocketEndpointConfig.this.transportMessage.getSessionId() != null) {
                    headers.put("Cookie", Collections.singletonList("JSESSIONID=" + GravityWebSocketEndpointConfig.this.transportMessage.getSessionId()));
                }
                headers.put("connectId", Collections.singletonList(GravityWebSocketEndpointConfig.this.transportMessage.getId()));
                headers.put("GDSClientType", Collections.singletonList(GravityWebSocketEndpointConfig.this.transportMessage.getClientType().toString()));
                String string = clientId = GravityWebSocketEndpointConfig.this.transportMessage.getClientId() != null ? GravityWebSocketEndpointConfig.this.transportMessage.getClientId() : GravityWebSocketEndpointConfig.this.channel.getClientId();
                if (clientId != null) {
                    headers.put("GDSClientId", Collections.singletonList(clientId));
                }
            }

            public void afterResponse(HandshakeResponse hr) {
            }
        }
    }
}

