/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.persistence.collection;

import java.util.Collection;
import java.util.Iterator;
import org.granite.client.persistence.collection.AbstractPersistentCollection;
import org.granite.client.persistence.collection.PersistentCollectionSnapshotFactory;
import org.granite.messaging.persistence.PersistentCollectionSnapshot;

public abstract class AbstractPersistentSimpleCollection<E, C extends Collection<E>>
extends AbstractPersistentCollection<C>
implements Collection<E> {
    private static final long serialVersionUID = 1L;

    @Override
    public int size() {
        if (!this.checkInitializedRead()) {
            return 0;
        }
        return ((Collection)this.getCollection()).size();
    }

    @Override
    public boolean isEmpty() {
        if (!this.checkInitializedRead()) {
            return true;
        }
        return ((Collection)this.getCollection()).isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!this.checkInitializedRead()) {
            return false;
        }
        return ((Collection)this.getCollection()).contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return new AbstractPersistentCollection.IteratorProxy(((Collection)this.getCollection()).iterator());
    }

    @Override
    public Object[] toArray() {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return ((Collection)this.getCollection()).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return ((Collection)this.getCollection()).toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.checkInitializedWrite();
        if (((Collection)this.getCollection()).add(e)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        this.checkInitializedWrite();
        if (((Collection)this.getCollection()).remove(o)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (!this.checkInitializedRead()) {
            return false;
        }
        return ((Collection)this.getCollection()).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkInitializedWrite();
        if (((Collection)this.getCollection()).addAll(c)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkInitializedWrite();
        if (((Collection)this.getCollection()).removeAll(c)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkInitializedWrite();
        if (((Collection)this.getCollection()).retainAll(c)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.checkInitializedWrite();
        if (!((Collection)this.getCollection()).isEmpty()) {
            ((Collection)this.getCollection()).clear();
            this.dirty();
        }
    }

    @Override
    protected PersistentCollectionSnapshot createSnapshot(Object io, boolean forReading) {
        PersistentCollectionSnapshotFactory factory = PersistentCollectionSnapshotFactory.newInstance(io);
        if (forReading || !this.wasInitialized()) {
            return factory.newPersistentCollectionSnapshot(this.getDetachedState());
        }
        return factory.newPersistentCollectionSnapshot(true, this.getDetachedState(), this.isDirty(), (Collection)this.getCollection());
    }
}

