/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.persistence.collection;

import java.io.ObjectInput;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.granite.client.persistence.collection.AbstractPersistentCollection;
import org.granite.client.persistence.collection.AbstractPersistentSimpleCollection;
import org.granite.client.persistence.collection.PersistentCollectionSnapshotFactory;
import org.granite.client.persistence.collection.PersistentSortedCollection;
import org.granite.messaging.persistence.PersistentCollectionSnapshot;

public class PersistentSortedSet<E>
extends AbstractPersistentSimpleCollection<E, SortedSet<E>>
implements SortedSet<E>,
PersistentSortedCollection<SortedSet<E>, E> {
    private static final long serialVersionUID = 1L;

    public PersistentSortedSet() {
    }

    public PersistentSortedSet(boolean initialized) {
        this(initialized ? new TreeSet() : null, false);
    }

    public PersistentSortedSet(SortedSet<E> collection) {
        this(collection, true);
    }

    public PersistentSortedSet(SortedSet<E> collection, boolean clone) {
        if (collection != null) {
            this.init(clone ? new TreeSet(collection) : collection, null, false);
        }
    }

    @Override
    protected void doInitialize(SortedSet<E> sortedSet, boolean empty) {
        this.init(empty ? new TreeSet(sortedSet.comparator()) : sortedSet, null, false);
    }

    @Override
    public Comparator<? super E> comparator() {
        return ((SortedSet)this.getCollection()).comparator();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return (AbstractPersistentCollection)this.new AbstractPersistentCollection.SortedSetProxy<E>(((SortedSet)this.getCollection()).subSet(fromElement, toElement));
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return (AbstractPersistentCollection)this.new AbstractPersistentCollection.SortedSetProxy<E>(((SortedSet)this.getCollection()).headSet(toElement));
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return (AbstractPersistentCollection)this.new AbstractPersistentCollection.SortedSetProxy<E>(((SortedSet)this.getCollection()).tailSet(fromElement));
    }

    @Override
    public E first() {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return ((SortedSet)this.getCollection()).first();
    }

    @Override
    public E last() {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return ((SortedSet)this.getCollection()).last();
    }

    @Override
    protected PersistentCollectionSnapshot createSnapshot(Object io, boolean forReading) {
        PersistentCollectionSnapshotFactory factory = PersistentCollectionSnapshotFactory.newInstance(io);
        if (forReading || !this.wasInitialized()) {
            return factory.newPersistentCollectionSnapshot(true, this.getDetachedState());
        }
        return factory.newPersistentCollectionSnapshot(true, this.getDetachedState(), this.isDirty(), (Collection)this.getCollection());
    }

    @Override
    protected void updateFromSnapshot(ObjectInput in, PersistentCollectionSnapshot snapshot) {
        if (snapshot.isInitialized()) {
            Comparator comparator = null;
            try {
                comparator = snapshot.newComparator(in);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create instance of comparator", e);
            }
            TreeSet set = new TreeSet(comparator);
            set.addAll(snapshot.getElementsAsCollection());
            this.init(set, snapshot.getDetachedState(), snapshot.isDirty());
        } else {
            this.init(null, snapshot.getDetachedState(), false);
        }
    }

    @Override
    public PersistentSortedSet<E> clone(boolean uninitialize) {
        PersistentSortedSet<E> set = new PersistentSortedSet<E>();
        if (this.wasInitialized() && !uninitialize) {
            set.init(this.getCollection(), null, this.isDirty());
        }
        return set;
    }
}

