/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.convert.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.convert.IllegalConverterArgumentException;
import org.granite.util.ArrayUtil;

public class Collection2Array
extends Converter {
    public Collection2Array(Converters converters) {
        super(converters);
    }

    @Override
    protected boolean internalCanConvert(Object value, Type targetType) {
        Type targetComponentType = ArrayUtil.getComponentType(targetType);
        if (targetComponentType == null) {
            return false;
        }
        if (value == null) {
            return true;
        }
        if (!(value instanceof Collection)) {
            return false;
        }
        if (targetComponentType.equals(Object.class)) {
            return true;
        }
        Converter itemConverter = null;
        for (Object item : (Collection)value) {
            if (itemConverter == null) {
                itemConverter = this.converters.getConverter(item, targetComponentType);
            } else if (!itemConverter.canConvert(item, targetComponentType)) {
                itemConverter = this.converters.getConverter(item, targetComponentType);
            }
            if (itemConverter != null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object internalConvert(Object value, Type targetType) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            Type targetComponentType = ArrayUtil.getComponentType(targetType);
            if (targetComponentType != null) {
                Converter itemConverter = null;
                Object array = ArrayUtil.newArray(targetComponentType, c.size());
                int i = 0;
                for (Object item : c) {
                    if (item != null && item.getClass() == targetComponentType) {
                        Array.set(array, i++, item);
                        continue;
                    }
                    if (itemConverter == null) {
                        itemConverter = this.converters.getConverter(item, targetComponentType);
                    } else if (!itemConverter.canConvert(item, targetComponentType)) {
                        itemConverter = this.converters.getConverter(item, targetComponentType);
                    }
                    if (itemConverter == null) {
                        throw new IllegalConverterArgumentException(this, value, targetType);
                    }
                    Array.set(array, i++, itemConverter.convert(item, targetComponentType));
                }
                return array;
            }
        }
        throw new IllegalConverterArgumentException(this, value, targetType);
    }
}

