/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util;

import java.util.ArrayList;
import java.util.List;
import org.granite.config.ConvertersConfig;
import org.granite.config.ExternalizersConfig;
import org.granite.config.api.AliasRegistryConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.MapProperty;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.amf.io.util.instantiator.AbstractInstantiator;

public abstract class ActionScriptClassDescriptor {
    protected final String type;
    protected final String instantiator;
    protected final byte encoding;
    protected final Externalizer externalizer;
    protected final Converters converters;
    protected final List<Property> properties;

    protected ActionScriptClassDescriptor(String type, byte encoding) {
        Object config = GraniteContext.getCurrentInstance().getGraniteConfig();
        this.type = type == null ? "" : ((AliasRegistryConfig)config).getAliasRegistry().getTypeForAlias(type);
        this.instantiator = ((ExternalizersConfig)config).getInstantiator(type);
        this.encoding = encoding;
        this.externalizer = this.findExternalizer();
        this.converters = ((ConvertersConfig)config).getConverters();
        this.properties = new ArrayList<Property>();
    }

    private Externalizer findExternalizer() {
        if (this.encoding != 1) {
            return null;
        }
        return ((ExternalizersConfig)GraniteContext.getCurrentInstance().getGraniteConfig()).getExternalizer(this.type);
    }

    public String getType() {
        return this.type;
    }

    public String getInstantiator() {
        return this.instantiator;
    }

    public Externalizer getExternalizer() {
        return this.externalizer;
    }

    public byte getEncoding() {
        return this.encoding;
    }

    public boolean isExternalizable() {
        return (this.encoding & 1) != 0;
    }

    public boolean isDynamic() {
        return (this.encoding & 2) != 0;
    }

    public abstract void defineProperty(String var1);

    public abstract Object newJavaInstance();

    public int getPropertiesCount() {
        return this.properties.size();
    }

    public Property getProperty(int index) {
        return this.properties.get(index);
    }

    public String getPropertyName(int index) {
        return this.properties.get(index).getName();
    }

    public void setPropertyValue(int index, Object instance, Object value) {
        Property prop = this.properties.get(index);
        if (value instanceof AbstractInstantiator) {
            ((AbstractInstantiator)value).addReferer(instance, prop);
        } else {
            prop.setValue(instance, value);
        }
    }

    public void setPropertyValue(String name, Object instance, Object value) {
        MapProperty prop = new MapProperty(this.converters, name);
        if (value instanceof AbstractInstantiator) {
            ((AbstractInstantiator)value).addReferer(instance, prop);
        } else {
            prop.setValue(instance, value);
        }
    }

    public String toString() {
        return this.getClass().getName() + " {\n" + "  type=" + this.type + ",\n" + "  instantiator=" + this.instantiator + ",\n" + "  encoding=" + this.encoding + ",\n" + "  externalizer=" + this.externalizer + ",\n" + "  converters=" + this.converters + ",\n" + "  properties=" + this.properties + "\n" + "}";
    }
}

