/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.codec.StandardCodec;

public abstract class AbstractStandardCodec<T>
implements StandardCodec<T> {
    protected JMFEncodingException newBadTypeJMFEncodingException(int jmfType, int parameterizedJmfType) {
        return new JMFEncodingException("Bad JMF type for " + this.getClass().getName() + ": " + jmfType + " (parameterized: " + parameterizedJmfType + ")");
    }

    protected String escape(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int max = s.length();
        for (int i = 0; i < max; ++i) {
            char c = s.charAt(i);
            this.escape(c, sb);
        }
        return sb.toString();
    }

    protected String escape(char c) {
        StringBuilder sb = new StringBuilder(6);
        this.escape(c, sb);
        return sb.toString();
    }

    protected void escape(char c, StringBuilder sb) {
        if (c >= ' ' && c <= '\u007f') {
            sb.append(c);
        } else {
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\'': {
                    sb.append("\\'");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                default: {
                    String hex = Integer.toHexString(c);
                    switch (hex.length()) {
                        case 1: {
                            sb.append("\\u000");
                            break;
                        }
                        case 2: {
                            sb.append("\\u00");
                            break;
                        }
                        case 3: {
                            sb.append("\\u0");
                            break;
                        }
                        default: {
                            sb.append("\\u");
                        }
                    }
                    sb.append(hex);
                    break;
                }
            }
        }
    }
}

