/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.util.Date;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.DateCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.LongUtil;

public class DateCodecImpl
extends AbstractStandardCodec<Date>
implements DateCodec {
    @Override
    public int getObjectType() {
        return 127;
    }

    @Override
    public Class<?> getObjectClass() {
        return Date.class;
    }

    @Override
    public void encode(OutputContext ctx, Date v) throws IOException {
        ctx.getOutputStream().write(127);
        LongUtil.encodeLong(ctx, v.getTime());
    }

    @Override
    public Date decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        return new Date(LongUtil.decodeLong(ctx));
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 127: {
                ctx.indentPrintLn(Date.class.getName() + ": " + this.decode(ctx, parameterizedJmfType));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }
}

