/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.StandardCodec;
import org.granite.messaging.jmf.codec.std.ObjectArrayCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractArrayCodec;
import org.granite.messaging.jmf.codec.std.impl.util.ClassNameUtil;
import org.granite.messaging.jmf.codec.std.impl.util.IntegerUtil;

public class ObjectArrayCodecImpl
extends AbstractArrayCodec
implements ObjectArrayCodec {
    @Override
    public int getObjectType() {
        return 6;
    }

    @Override
    public boolean canEncode(Object v) {
        return v.getClass().isArray() && !this.getComponentType(v).isPrimitive();
    }

    @Override
    public void encode(OutputContext ctx, Object v) throws IOException {
        int indexOfStoredObject = ctx.indexOfObject(v);
        if (indexOfStoredObject != -1) {
            int count = IntegerUtil.significantIntegerBytesCount0(indexOfStoredObject);
            ctx.getOutputStream().write(0x80 | count << 4 | 6);
            IntegerUtil.encodeInteger(ctx, indexOfStoredObject, count);
        } else {
            ctx.addToObjects(v);
            AbstractArrayCodec.ArrayStructure structure = new AbstractArrayCodec.ArrayStructure(v);
            String className = ctx.getAlias(structure.componentType.getName());
            int length = Array.getLength(v);
            int count = IntegerUtil.significantIntegerBytesCount0(length);
            OutputStream os = ctx.getOutputStream();
            if (structure.dimensions == 0) {
                os.write(count << 4 | 6);
                IntegerUtil.encodeInteger(ctx, length, count);
                ClassNameUtil.encodeClassName(ctx, className);
                this.writeObjectArrayContent0(ctx, v);
            } else {
                os.write(0x40 | count << 4 | 6);
                IntegerUtil.encodeInteger(ctx, length, count);
                ClassNameUtil.encodeClassName(ctx, className);
                os.write(structure.dimensions);
                this.writeObjectArrayContent(ctx, v, structure.componentType, structure.dimensions);
            }
        }
    }

    protected void writeObjectArrayContent(OutputContext ctx, Object v, Class<?> componentType, int dimensions) throws IOException {
        int length = Array.getLength(v);
        if (length == 0) {
            return;
        }
        boolean writeObjectArrayContent0 = --dimensions == 0;
        OutputStream os = ctx.getOutputStream();
        for (int index = 0; index < length; ++index) {
            Object item = Array.get(v, index);
            if (item == null) {
                os.write(120);
                continue;
            }
            int indexOfStoredObject = ctx.indexOfObject(item);
            if (indexOfStoredObject != -1) {
                int count = IntegerUtil.significantIntegerBytesCount0(indexOfStoredObject);
                ctx.getOutputStream().write(0x80 | count << 4 | 6);
                IntegerUtil.encodeInteger(ctx, indexOfStoredObject, count);
                continue;
            }
            ctx.addToObjects(item);
            int itemLength = Array.getLength(item);
            int count = IntegerUtil.significantIntegerBytesCount0(itemLength);
            os.write(count << 4 | 6);
            IntegerUtil.encodeInteger(ctx, itemLength, count);
            Class<?> itemType = this.getComponentType(item);
            String className = ctx.getAlias(itemType.getName());
            ClassNameUtil.encodeClassName(ctx, className);
            if (writeObjectArrayContent0) {
                this.writeObjectArrayContent0(ctx, item);
                continue;
            }
            this.writeObjectArrayContent(ctx, item, itemType, dimensions);
        }
    }

    protected void writeObjectArrayContent0(OutputContext ctx, Object v) throws IOException {
        int length = Array.getLength(v);
        if (length == 0) {
            return;
        }
        for (int index = 0; index < length; ++index) {
            ctx.writeObject(Array.get(v, index));
        }
    }

    @Override
    public Object decode(InputContext ctx, int parameterizedJmfType) throws IOException, ClassNotFoundException {
        Object v = null;
        int indexOrLength = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >> 4 & 3);
        if ((parameterizedJmfType & 0x80) != 0) {
            v = ctx.getObject(indexOrLength);
        } else {
            String componentTypeName = ctx.getAlias(ClassNameUtil.decodeClassName(ctx));
            int dimensions = (parameterizedJmfType & 0x40) == 0 ? 0 : ctx.safeRead();
            Class<?> componentType = ctx.getSharedContext().getReflection().loadClass(componentTypeName);
            v = dimensions == 0 ? this.readObjectArray0(ctx, componentType, indexOrLength) : this.readObjectArray(ctx, componentType, indexOrLength, dimensions);
        }
        return v;
    }

    protected Object readObjectArray(InputContext ctx, Class<?> componentType, int length, int dimensions) throws IOException, ClassNotFoundException {
        Object v = this.newArray(componentType, length, dimensions);
        ctx.addToObjects(v);
        boolean readObjectArray0 = --dimensions == 0;
        for (int index = 0; index < length; ++index) {
            int eltParameterizedJmfType = ctx.safeRead();
            if (eltParameterizedJmfType == 120) {
                Array.set(v, index, null);
                continue;
            }
            int eltIndexOrLength = IntegerUtil.decodeInteger(ctx, eltParameterizedJmfType >>> 4 & 3);
            if ((eltParameterizedJmfType & 0x80) != 0) {
                Array.set(v, index, ctx.getObject(eltIndexOrLength));
                continue;
            }
            String eltClassName = ctx.getAlias(ClassNameUtil.decodeClassName(ctx));
            Class<?> eltComponentType = ctx.getReflection().loadClass(eltClassName);
            if (readObjectArray0) {
                Array.set(v, index, this.readObjectArray0(ctx, eltComponentType, eltIndexOrLength));
                continue;
            }
            Array.set(v, index, this.readObjectArray(ctx, eltComponentType, eltIndexOrLength, dimensions));
        }
        return v;
    }

    protected Object readObjectArray0(InputContext ctx, Class<?> componentType, int length) throws IOException, ClassNotFoundException {
        Object v = Array.newInstance(componentType, length);
        ctx.addToObjects(v);
        for (int index = 0; index < length; ++index) {
            Array.set(v, index, ctx.readObject());
        }
        return v;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 6) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int indexOrLength = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 4 & 3);
        if ((parameterizedJmfType & 0x80) != 0) {
            ctx.indentPrintLn("<" + ctx.getObject(indexOrLength) + "@" + indexOrLength + ">");
        } else {
            int dimensions;
            String eltClassName = ctx.getAlias(ClassNameUtil.decodeClassName(ctx));
            int n = dimensions = (parameterizedJmfType & 0x40) == 0 ? 0 : ctx.safeRead();
            if (dimensions == 0) {
                this.dumpObjectArray0(ctx, eltClassName, indexOrLength);
            } else {
                this.dumpObjectArray(ctx, eltClassName, indexOrLength, dimensions);
            }
        }
    }

    protected void dumpObjectArray(DumpContext ctx, String componentType, int length, int dimensions) throws IOException {
        String v = this.newDumpObjectArray(componentType, length, 0);
        int indexOfStoredObject = ctx.addToObjects(v);
        ctx.indentPrintLn(v + "@" + indexOfStoredObject + ": {");
        ctx.incrIndent(1);
        boolean dumpObjectArray0 = --dimensions == 0;
        for (int index = 0; index < length; ++index) {
            int eltParameterizedJmfType = ctx.safeRead();
            int eltJmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(eltParameterizedJmfType);
            if (eltJmfType == 120) {
                ctx.indentPrintLn("null");
                continue;
            }
            if (eltJmfType == 6) {
                int eltIndexOrLength = IntegerUtil.decodeInteger(ctx, eltParameterizedJmfType >>> 4 & 3);
                if ((eltParameterizedJmfType & 0x80) != 0) {
                    ctx.indentPrintLn("<" + ctx.getObject(eltIndexOrLength) + "@" + eltIndexOrLength + ">");
                    continue;
                }
                String eltClassName = ctx.getAlias(ClassNameUtil.decodeClassName(ctx));
                if (dumpObjectArray0) {
                    this.dumpObjectArray0(ctx, eltClassName, eltIndexOrLength);
                    continue;
                }
                this.dumpObjectArray(ctx, eltClassName, eltIndexOrLength, dimensions);
                continue;
            }
            this.newBadTypeJMFEncodingException(eltJmfType, eltParameterizedJmfType);
        }
        ctx.incrIndent(-1);
        ctx.indentPrintLn("}");
    }

    protected void dumpObjectArray0(DumpContext ctx, String componentType, int length) throws IOException {
        String v = this.newDumpObjectArray(componentType, length, 0);
        int indexOfStoredObject = ctx.addToObjects(v);
        ctx.indentPrintLn(v + "@" + indexOfStoredObject + ": {");
        ctx.incrIndent(1);
        for (int index = 0; index < length; ++index) {
            int parameterizedJmfType = ctx.safeRead();
            int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
            StandardCodec codec = ctx.getSharedContext().getCodecRegistry().getCodec(jmfType);
            if (codec == null) {
                throw new JMFEncodingException("No codec for JMF type: " + jmfType);
            }
            codec.dump(ctx, parameterizedJmfType);
        }
        ctx.incrIndent(-1);
        ctx.indentPrintLn("}");
    }

    protected String newDumpObjectArray(String componentTypeName, int length, int dimensions) {
        StringBuilder sb = new StringBuilder(componentTypeName);
        sb.append('[').append(length).append(']');
        for (int i = 0; i < dimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }
}

