/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.SqlDateCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.LongUtil;

public class SqlDateCodecImpl
extends AbstractStandardCodec<Date>
implements SqlDateCodec {
    @Override
    public int getObjectType() {
        return 248;
    }

    @Override
    public Class<?> getObjectClass() {
        return Date.class;
    }

    @Override
    public void encode(OutputContext ctx, Date v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        os.write(248);
        LongUtil.encodeLong(ctx, v.getTime());
    }

    @Override
    public Date decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        return new Date(LongUtil.decodeLong(ctx));
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 248: {
                ctx.indentPrintLn(Date.class.getName() + ": " + this.decode(ctx, parameterizedJmfType));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }
}

