/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.granite.tide.data.CollectionChange;
import org.granite.tide.data.CollectionChanges;

public class Change
implements Externalizable,
Comparable<Change> {
    private static final long serialVersionUID = 1L;
    private String className;
    private String uid;
    private Serializable id;
    private Number version;
    private Map<String, Object> changes;
    private boolean local;

    public Change() {
        this.local = false;
    }

    public Change(String className, Serializable id, Number version, String uid) {
        this.className = className;
        this.id = id;
        this.version = version;
        this.uid = uid;
        this.changes = new HashMap<String, Object>();
        this.local = false;
    }

    public Change(String className, Serializable id, Number version, String uid, boolean local) {
        this.className = className;
        this.id = id;
        this.version = version;
        this.uid = uid;
        this.changes = new HashMap<String, Object>();
        this.local = local;
    }

    public String getClassName() {
        return this.className;
    }

    public String getUid() {
        return this.uid;
    }

    public Serializable getId() {
        return this.id;
    }

    public Number getVersion() {
        return this.version;
    }

    public void updateVersion(Number version) {
        this.version = version;
    }

    public Map<String, Object> getChanges() {
        return this.changes;
    }

    public boolean isEmpty() {
        return this.changes.size() == 0;
    }

    public Object getChange(String key) {
        return this.changes.get(key);
    }

    public <T> T getChange(String key, Class<T> cast) {
        return (T)this.changes.get(key);
    }

    public CollectionChanges getCollectionChange(String key) {
        return (CollectionChanges)this.changes.get(key);
    }

    public boolean isLocal() {
        return this.local;
    }

    public void addCollectionChanges(String propertyName, CollectionChange ... collChanges) {
        CollectionChanges existingChanges = (CollectionChanges)this.changes.get(propertyName);
        if (existingChanges == null) {
            this.changes.put(propertyName, new CollectionChanges(collChanges));
        } else {
            CollectionChange[] newChanges = new CollectionChange[existingChanges.getChanges().length + collChanges.length];
            System.arraycopy(existingChanges.getChanges(), 0, newChanges, 0, existingChanges.getChanges().length);
            System.arraycopy(collChanges, 0, newChanges, existingChanges.getChanges().length, collChanges.length);
            existingChanges.setChanges(newChanges);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getClassName().indexOf(".") > 0) {
            sb.append(this.getClassName().substring(this.getClassName().lastIndexOf(".") + 1));
        } else {
            sb.append(this.getClassName());
        }
        sb.append(':').append(this.getUid()).append(":").append(this.getId()).append(':').append(this.getVersion()).append("={");
        boolean first = true;
        for (Map.Entry<String, Object> change : this.getChanges().entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(change.getKey()).append(": ").append(change.getValue());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.uid);
        out.writeObject(this.id);
        out.writeObject(this.version);
        out.writeObject(this.changes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        this.uid = (String)in.readObject();
        this.id = (Serializable)in.readObject();
        this.version = (Number)in.readObject();
        this.changes = (Map)in.readObject();
    }

    @Override
    public int compareTo(Change o) {
        if (!this.className.equals(o.getClassName())) {
            return this.className.compareTo(o.getClassName());
        }
        if (!this.uid.equals(o.getUid())) {
            return this.uid.compareTo(o.getUid());
        }
        if (this.version == null) {
            return o.getVersion() == null ? 0 : -1;
        }
        if (this.version.equals(o.getVersion())) {
            return 0;
        }
        if (o.getVersion() == null) {
            return 1;
        }
        return this.version.longValue() > o.getVersion().longValue() ? 1 : -1;
    }
}

