/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.granite.client.messaging.RemoteAlias;
import org.granite.client.messaging.RemoteAliasScanner;
import org.granite.client.platform.Platform;
import org.granite.logging.Logger;
import org.granite.messaging.AliasRegistry;

public class ClientAliasRegistry
implements AliasRegistry {
    private static final Logger log = Logger.getLogger(ClientAliasRegistry.class);
    private Map<String, String> serverToClientAliases = new HashMap<String, String>();
    private Map<String, String> clientToServerAliases = new HashMap<String, String>();

    @Override
    public void scan(Set<String> packageNames) {
        if (packageNames != null && !packageNames.isEmpty()) {
            RemoteAliasScanner scanner = Platform.getInstance().newRemoteAliasScanner();
            Set<Class<?>> aliases = scanner.scan(packageNames);
            for (Class<?> alias : aliases) {
                this.registerAlias(alias);
            }
            log.debug("Using remote aliases: %s", aliases);
        }
    }

    public void registerAlias(Class<?> remoteAliasAnnotatedClass) {
        RemoteAlias remoteAlias = remoteAliasAnnotatedClass.getAnnotation(RemoteAlias.class);
        if (remoteAlias == null) {
            throw new IllegalArgumentException(remoteAliasAnnotatedClass.getName() + " isn't annotated with " + RemoteAlias.class.getName());
        }
        this.registerAlias(remoteAliasAnnotatedClass.getName(), remoteAlias.value());
    }

    public void registerAliases(Class<?> ... remoteAliasAnnotatedClasses) {
        for (Class<?> remoteAliasAnnotatedClass : remoteAliasAnnotatedClasses) {
            this.registerAlias(remoteAliasAnnotatedClass);
        }
    }

    public void registerAlias(String clientClassName, String serverClassName) {
        if (clientClassName.length() == 0 || serverClassName.length() == 0) {
            throw new IllegalArgumentException("Empty class name: " + clientClassName + " / " + serverClassName);
        }
        this.clientToServerAliases.put(clientClassName, serverClassName);
        this.serverToClientAliases.put(serverClassName, clientClassName);
    }

    public void registerAliases(Map<String, String> clientToServerAliases) {
        for (Map.Entry<String, String> clientToServerAlias : clientToServerAliases.entrySet()) {
            this.registerAlias(clientToServerAlias.getKey(), clientToServerAlias.getValue());
        }
    }

    @Override
    public String getAliasForType(String className) {
        String alias = this.clientToServerAliases.get(className);
        return alias != null ? alias : className;
    }

    @Override
    public String getTypeForAlias(String alias) {
        String className = this.serverToClientAliases.get(alias);
        return className != null ? className : alias;
    }
}

