/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel;

import java.net.URI;
import org.granite.client.configuration.Configuration;
import org.granite.client.messaging.channel.AbstractChannelFactory;
import org.granite.client.messaging.channel.amf.AMFMessagingChannel;
import org.granite.client.messaging.channel.amf.AMFRemotingChannel;
import org.granite.client.messaging.transport.Transport;
import org.granite.client.platform.Platform;
import org.granite.util.ContentType;

public class AMFChannelFactory
extends AbstractChannelFactory {
    private final Configuration defaultConfiguration;

    public AMFChannelFactory() {
        this((Object)null, null, null, null);
    }

    public AMFChannelFactory(Object context) {
        this(context, null, null, null);
    }

    public AMFChannelFactory(Object context, Configuration defaultConfiguration) {
        this(context, null, null, defaultConfiguration);
    }

    public AMFChannelFactory(Object context, Transport remotingTransport, Transport messagingTransport) {
        this(context, remotingTransport, messagingTransport, null);
    }

    public AMFChannelFactory(Object context, Transport remotingTransport, Transport messagingTransport, Configuration defaultConfiguration) {
        super(ContentType.AMF, context, remotingTransport, messagingTransport);
        this.defaultConfiguration = defaultConfiguration != null ? defaultConfiguration : Platform.getInstance().newConfiguration();
        this.aliasRegistry = this.defaultConfiguration.getGraniteConfig().getAliasRegistry();
    }

    @Override
    public AMFRemotingChannel newRemotingChannel(String id, URI uri) {
        return this.newRemotingChannel(id, uri, 5);
    }

    @Override
    public AMFRemotingChannel newRemotingChannel(String id, URI uri, int maxConcurrentRequests) {
        return new AMFRemotingChannel(this.getRemotingTransport(), this.defaultConfiguration, id, uri, maxConcurrentRequests);
    }

    @Override
    public AMFMessagingChannel newMessagingChannel(String id, URI uri) {
        return new AMFMessagingChannel(this.getMessagingTransport(), this.defaultConfiguration, id, uri);
    }

    public Configuration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }
}

