/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.granite.client.messaging.ClientAliasRegistry;
import org.granite.client.messaging.channel.ChannelFactory;
import org.granite.client.messaging.channel.MessagingChannel;
import org.granite.client.messaging.channel.RemotingChannel;
import org.granite.client.messaging.transport.Transport;
import org.granite.client.messaging.transport.TransportException;
import org.granite.client.platform.Platform;
import org.granite.messaging.AliasRegistry;
import org.granite.util.ContentType;

public abstract class AbstractChannelFactory
implements ChannelFactory {
    protected final ContentType contentType;
    protected Transport remotingTransport = null;
    protected Transport messagingTransport = null;
    protected Object context = null;
    protected Set<String> scanPackageNames = null;
    protected AliasRegistry aliasRegistry = null;
    protected Long defaultTimeToLive = null;

    protected AbstractChannelFactory(ContentType contentType) {
        this(contentType, null, null, null);
    }

    protected AbstractChannelFactory(ContentType contentType, Object context) {
        this(contentType, context, null, null);
    }

    protected AbstractChannelFactory(ContentType contentType, Object context, Transport remotingTransport, Transport messagingTransport) {
        this.contentType = contentType;
        this.context = context;
        this.remotingTransport = remotingTransport;
        this.messagingTransport = messagingTransport;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public void setContext(Object context) {
        this.context = context;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public long getDefaultTimeToLive() {
        return this.defaultTimeToLive != null ? this.defaultTimeToLive : -1L;
    }

    @Override
    public void setDefaultTimeToLive(long defaultTimeToLive) {
        this.defaultTimeToLive = defaultTimeToLive;
    }

    @Override
    public void setAliasRegistry(AliasRegistry aliasRegistry) {
        this.aliasRegistry = aliasRegistry;
    }

    @Override
    public Transport getRemotingTransport() {
        return this.remotingTransport;
    }

    @Override
    public void setRemotingTransport(Transport remotingTransport) {
        this.remotingTransport = remotingTransport;
    }

    @Override
    public Transport getMessagingTransport() {
        return this.messagingTransport;
    }

    @Override
    public void setMessagingTransport(Transport messagingTransport) {
        this.messagingTransport = messagingTransport;
    }

    public void setScanPackageNames(String ... packageNames) {
        this.scanPackageNames = packageNames != null ? new HashSet<String>(Arrays.asList(packageNames)) : null;
    }

    @Override
    public void setScanPackageNames(Set<String> packageNames) {
        this.scanPackageNames = packageNames;
    }

    @Override
    public void start() {
        Platform platform = Platform.getInstance();
        platform.setContext(this.context);
        if (this.remotingTransport == null) {
            this.remotingTransport = Platform.getInstance().newRemotingTransport();
        }
        if (!this.remotingTransport.isStarted() && !this.remotingTransport.start()) {
            throw new TransportException("Could not start remoting transport: " + this.remotingTransport);
        }
        if (this.messagingTransport == null) {
            this.messagingTransport = Platform.getInstance().newMessagingTransport();
            if (this.messagingTransport == null) {
                this.messagingTransport = this.remotingTransport;
            }
        } else if (!this.messagingTransport.isStarted() && !this.messagingTransport.start()) {
            throw new TransportException("Could not start messaging transport: " + this.messagingTransport);
        }
        if (this.aliasRegistry == null) {
            this.aliasRegistry = new ClientAliasRegistry();
        }
        if (this.scanPackageNames != null) {
            this.aliasRegistry.scan(this.scanPackageNames);
        }
    }

    @Override
    public void stop() {
        this.aliasRegistry = null;
        this.stop(true);
    }

    @Override
    public void stop(boolean stopTransports) {
        if (stopTransports) {
            if (this.remotingTransport != null && this.remotingTransport.isStarted()) {
                this.remotingTransport.stop();
                this.remotingTransport = null;
            }
            if (this.messagingTransport != null && this.messagingTransport.isStarted()) {
                this.messagingTransport.stop();
                this.messagingTransport = null;
            }
        }
    }

    @Override
    public RemotingChannel newRemotingChannel(String id, String uri) {
        try {
            RemotingChannel channel = this.newRemotingChannel(id, new URI(uri));
            if (this.defaultTimeToLive != null) {
                channel.setDefaultTimeToLive(this.defaultTimeToLive);
            }
            return channel;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad uri: " + uri, e);
        }
    }

    @Override
    public RemotingChannel newRemotingChannel(String id, String uri, int maxConcurrentRequests) {
        try {
            RemotingChannel channel = this.newRemotingChannel(id, new URI(uri), maxConcurrentRequests);
            if (this.defaultTimeToLive != null) {
                channel.setDefaultTimeToLive(this.defaultTimeToLive);
            }
            return channel;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad uri: " + uri, e);
        }
    }

    @Override
    public MessagingChannel newMessagingChannel(String id, String uri) {
        try {
            MessagingChannel channel = this.newMessagingChannel(id, new URI(uri));
            if (this.defaultTimeToLive != null) {
                channel.setDefaultTimeToLive(this.defaultTimeToLive);
            }
            return channel;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad uri: " + uri, e);
        }
    }
}

