/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.granite.client.messaging.AllInOneResponseListener;
import org.granite.client.messaging.ResponseListener;
import org.granite.client.messaging.ResponseListenerDispatcher;
import org.granite.client.messaging.channel.AbstractChannel;
import org.granite.client.messaging.channel.AsyncToken;
import org.granite.client.messaging.channel.Credentials;
import org.granite.client.messaging.channel.ImmediateFailureResponseMessageFuture;
import org.granite.client.messaging.channel.ResponseMessageFuture;
import org.granite.client.messaging.events.Event;
import org.granite.client.messaging.messages.MessageChain;
import org.granite.client.messaging.messages.RequestMessage;
import org.granite.client.messaging.messages.ResponseMessage;
import org.granite.client.messaging.messages.requests.LoginMessage;
import org.granite.client.messaging.messages.requests.LogoutMessage;
import org.granite.client.messaging.messages.requests.PingMessage;
import org.granite.client.messaging.messages.responses.FaultMessage;
import org.granite.client.messaging.messages.responses.ResultMessage;
import org.granite.client.messaging.transport.Transport;
import org.granite.client.messaging.transport.TransportFuture;
import org.granite.client.messaging.transport.TransportMessage;
import org.granite.client.messaging.transport.TransportStopListener;
import org.granite.logging.Logger;

public abstract class AbstractHTTPChannel
extends AbstractChannel<Transport>
implements TransportStopListener,
Runnable {
    private static final Logger log = Logger.getLogger(AbstractHTTPChannel.class);
    private final BlockingQueue<AsyncToken> tokensQueue = new LinkedBlockingQueue<AsyncToken>();
    private final ConcurrentMap<String, AsyncToken> tokensMap = new ConcurrentHashMap<String, AsyncToken>();
    private Thread senderThread = null;
    private Semaphore connections;
    private Timer timer = null;
    protected volatile boolean pinged = false;
    protected volatile boolean authenticated = false;
    protected volatile int maxConcurrentRequests;
    protected volatile long defaultTimeToLive = DEFAULT_TIME_TO_LIVE;

    public AbstractHTTPChannel(Transport transport, String id, URI uri, int maxConcurrentRequests) {
        super(transport, id, uri);
        if (maxConcurrentRequests < 1) {
            throw new IllegalArgumentException("maxConcurrentRequests must be greater or equal to 1");
        }
        this.maxConcurrentRequests = maxConcurrentRequests;
    }

    protected abstract TransportMessage createTransportMessage(AsyncToken var1) throws UnsupportedEncodingException;

    protected abstract ResponseMessage decodeResponse(InputStream var1) throws IOException;

    protected boolean schedule(TimerTask timerTask, long delay) {
        if (this.timer != null) {
            this.timer.schedule(timerTask, delay);
            return true;
        }
        return false;
    }

    @Override
    public long getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    @Override
    public void setDefaultTimeToLive(long defaultTimeToLive) {
        this.defaultTimeToLive = defaultTimeToLive;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    @Override
    public void onStop(Transport transport) {
        this.stop();
    }

    @Override
    public synchronized boolean start() {
        if (this.senderThread == null) {
            log.info("Starting channel %s...", this.id);
            this.senderThread = new Thread(this);
            try {
                this.timer = new Timer(this.id + "_timer", true);
                this.connections = new Semaphore(this.maxConcurrentRequests);
                this.senderThread.start();
                this.transport.addStopListener(this);
                log.info("Channel %s started.", this.id);
            }
            catch (Exception e) {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.connections = null;
                this.senderThread = null;
                log.error(e, "Channel %s failed to start.", this.id);
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.senderThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean stop() {
        if (this.senderThread != null) {
            log.info("Stopping channel %s...", this.id);
            if (this.timer != null) {
                try {
                    this.timer.cancel();
                }
                catch (Exception e) {
                    log.error(e, "Channel %s timer failed to stop.", this.id);
                }
                finally {
                    this.timer = null;
                }
            }
            this.connections = null;
            this.tokensMap.clear();
            this.tokensQueue.clear();
            Thread thread = this.senderThread;
            this.senderThread = null;
            thread.interrupt();
            this.pinged = false;
            this.clientId = null;
            this.authenticated = false;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                Credentials credentials;
                AsyncToken token = this.tokensQueue.take();
                if (token.isDone()) continue;
                if (!this.pinged) {
                    ResultMessage result = this.sendBlockingToken(new PingMessage(this.clientId), token);
                    if (result == null) continue;
                    this.clientId = result.getClientId();
                    this.pinged = true;
                }
                if (!this.authenticated && (credentials = this.credentials) != null) {
                    ResultMessage result = this.sendBlockingToken(new LoginMessage(this.clientId, credentials), token);
                    if (result == null) continue;
                    this.authenticated = true;
                }
                this.sendToken(token);
            }
            catch (InterruptedException e) {
                log.info("Channel %s stopped.", this.id);
                break;
            }
            catch (Exception e) {
                log.error(e, "Channel %s got an unexepected exception.", this.id);
            }
        }
    }

    private ResultMessage sendBlockingToken(RequestMessage request, AsyncToken dependentToken) {
        request.setTimestamp(dependentToken.getRequest().getTimestamp());
        request.setTimeToLive(dependentToken.getRequest().getTimeToLive());
        AsyncToken blockingToken = new AsyncToken(request);
        try {
            this.timer.schedule((TimerTask)blockingToken, blockingToken.getRequest().getRemainingTimeToLive());
        }
        catch (IllegalArgumentException e) {
            dependentToken.dispatchTimeout(System.currentTimeMillis());
            return null;
        }
        catch (Exception e) {
            dependentToken.dispatchFailure(e);
            return null;
        }
        try {
            if (!this.sendToken(blockingToken)) {
                return null;
            }
        }
        catch (Exception e) {
            dependentToken.dispatchFailure(e);
            return null;
        }
        try {
            FaultMessage faultMessage;
            ResponseMessage response = blockingToken.get();
            if (response instanceof ResultMessage) {
                return (ResultMessage)response;
            }
            if (response instanceof FaultMessage) {
                faultMessage = (FaultMessage)response.copy(dependentToken.getRequest().getId());
                if (dependentToken.getRequest() instanceof MessageChain) {
                    ResponseMessage nextResponse = faultMessage;
                    for (Object nextRequest = ((MessageChain)((Object)dependentToken.getRequest())).getNext(); nextRequest != null; nextRequest = nextRequest.getNext()) {
                        nextResponse.setNext(response.copy(nextRequest.getId()));
                        nextResponse = (ResponseMessage)nextResponse.getNext();
                    }
                }
            } else {
                throw new RuntimeException("Unknow response message type: " + response);
            }
            dependentToken.dispatchFault(faultMessage);
        }
        catch (InterruptedException e) {
            dependentToken.dispatchFailure(e);
        }
        catch (TimeoutException e) {
            dependentToken.dispatchTimeout(System.currentTimeMillis());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Exception) {
                dependentToken.dispatchFailure((Exception)e.getCause());
            } else {
                dependentToken.dispatchFailure(e);
            }
        }
        catch (Exception e) {
            dependentToken.dispatchFailure(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendToken(AsyncToken token) {
        boolean releaseConnections = false;
        try {
            if (!this.connections.tryAcquire(token.getRequest().getRemainingTimeToLive(), TimeUnit.MILLISECONDS)) {
                token.dispatchTimeout(System.currentTimeMillis());
                boolean bl = false;
                return bl;
            }
            releaseConnections = true;
            if (token.isDone()) {
                boolean bl = false;
                return bl;
            }
            token.getRequest().setClientId(this.clientId);
            if (this.tokensMap.putIfAbsent(token.getId(), token) != null) {
                throw new RuntimeException("MessageId isn't unique: " + token.getId());
            }
            TransportFuture transportFuture = this.transport.send(this, this.createTransportMessage(token));
            ChannelResponseListener channelListener = new ChannelResponseListener(token.getId(), this.tokensMap, transportFuture, this.connections);
            Event tokenEvent = token.setChannelListener(channelListener);
            if (tokenEvent != null) {
                ResponseListenerDispatcher.dispatch(channelListener, tokenEvent);
            }
            releaseConnections = false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.tokensMap.remove(token.getId());
            token.dispatchFailure(e);
            if (this.timer != null) {
                this.timer.purge();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (releaseConnections) {
                this.connections.release();
            }
        }
    }

    protected RequestMessage getRequest(String id) {
        AsyncToken token = (AsyncToken)this.tokensMap.get(id);
        return token != null ? token.getRequest() : null;
    }

    @Override
    public ResponseMessageFuture send(RequestMessage request, ResponseListener ... listeners) {
        if (request == null) {
            throw new NullPointerException("request cannot be null");
        }
        if (!this.start()) {
            throw new RuntimeException("Channel not started");
        }
        AsyncToken token = new AsyncToken(request, listeners);
        request.setTimestamp(System.currentTimeMillis());
        if (request.getTimeToLive() <= 0L) {
            request.setTimeToLive(this.defaultTimeToLive);
        }
        try {
            this.timer.schedule((TimerTask)token, request.getRemainingTimeToLive());
            this.tokensQueue.add(token);
        }
        catch (Exception e) {
            log.error(e, "Could not add token to queue: %s", token);
            token.dispatchFailure(e);
            return new ImmediateFailureResponseMessageFuture(e);
        }
        return token;
    }

    @Override
    public ResponseMessageFuture logout(ResponseListener ... listeners) {
        this.credentials = null;
        this.authenticated = false;
        return this.send(new LogoutMessage(), listeners);
    }

    @Override
    public void onMessage(InputStream is) {
        try {
            ResponseMessage response = this.decodeResponse(is);
            if (response != null) {
                AsyncToken token = (AsyncToken)this.tokensMap.remove(response.getCorrelationId());
                if (token == null) {
                    log.warn("Unknown correlation id: %s", response.getCorrelationId());
                    return;
                }
                switch (response.getType()) {
                    case RESULT: {
                        token.dispatchResult((ResultMessage)response);
                        break;
                    }
                    case FAULT: {
                        FaultMessage faultMessage = (FaultMessage)response;
                        if (this.isAuthenticated() && faultMessage.getCode() == FaultMessage.Code.NOT_LOGGED_IN || faultMessage.getCode() == FaultMessage.Code.SESSION_EXPIRED) {
                            this.authenticated = false;
                            this.credentials = null;
                        }
                        token.dispatchFault((FaultMessage)response);
                        break;
                    }
                    default: {
                        token.dispatchFailure(new RuntimeException("Unknown message type: " + response));
                    }
                }
                if (this.timer != null) {
                    this.timer.purge();
                }
            }
        }
        catch (Exception e) {
            log.error(e, "Could not deserialize or dispatch incoming messages", new Object[0]);
        }
    }

    @Override
    public void onError(TransportMessage message, Exception e) {
        AsyncToken token;
        if (message != null && (token = (AsyncToken)this.tokensMap.remove(message.getId())) != null) {
            token.dispatchFailure(e);
            if (this.timer != null) {
                this.timer.purge();
            }
        }
    }

    @Override
    public void onCancelled(TransportMessage message) {
        AsyncToken token = (AsyncToken)this.tokensMap.remove(message.getId());
        if (token != null) {
            token.dispatchCancelled();
            if (this.timer != null) {
                this.timer.purge();
            }
        }
    }

    private static class ChannelResponseListener
    extends AllInOneResponseListener {
        private final String tokenId;
        private final ConcurrentMap<String, AsyncToken> tokensMap;
        private final TransportFuture transportFuture;
        private final Semaphore connections;

        public ChannelResponseListener(String tokenId, ConcurrentMap<String, AsyncToken> tokensMap, TransportFuture transportFuture, Semaphore connections) {
            this.tokenId = tokenId;
            this.tokensMap = tokensMap;
            this.transportFuture = transportFuture;
            this.connections = connections;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(Event event) {
            try {
                this.tokensMap.remove(this.tokenId);
                if ((event.getType() == Event.Type.TIMEOUT || event.getType() == Event.Type.CANCELLED) && this.transportFuture != null) {
                    this.transportFuture.cancel();
                }
            }
            finally {
                this.connections.release();
            }
        }
    }
}

