/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.granite.client.messaging.ResponseListener;
import org.granite.client.messaging.ResponseListenerDispatcher;
import org.granite.client.messaging.channel.ResponseMessageFuture;
import org.granite.client.messaging.events.CancelledEvent;
import org.granite.client.messaging.events.Event;
import org.granite.client.messaging.events.FailureEvent;
import org.granite.client.messaging.events.FaultEvent;
import org.granite.client.messaging.events.ResultEvent;
import org.granite.client.messaging.events.TimeoutEvent;
import org.granite.client.messaging.messages.RequestMessage;
import org.granite.client.messaging.messages.ResponseMessage;
import org.granite.client.messaging.messages.responses.FaultMessage;
import org.granite.client.messaging.messages.responses.ResultMessage;

public class AsyncToken
extends TimerTask
implements ResponseMessageFuture {
    private final RequestMessage request;
    private final List<ResponseListener> listeners;
    private Event event;
    private ResponseListener channelListener;

    public AsyncToken(RequestMessage request) {
        this(request, (ResponseListener[])null);
    }

    public AsyncToken(RequestMessage request, ResponseListener listener) {
        ResponseListener[] responseListenerArray;
        if (listener == null) {
            responseListenerArray = null;
        } else {
            ResponseListener[] responseListenerArray2 = new ResponseListener[1];
            responseListenerArray = responseListenerArray2;
            responseListenerArray2[0] = listener;
        }
        this(request, responseListenerArray);
    }

    public AsyncToken(RequestMessage request, ResponseListener[] listeners) {
        this.listeners = new ArrayList<ResponseListener>();
        this.event = null;
        this.channelListener = null;
        if (request == null) {
            throw new NullPointerException("request cannot be null");
        }
        this.request = request;
        if (listeners != null) {
            for (ResponseListener listener : listeners) {
                if (listener == null) {
                    throw new NullPointerException("listeners cannot contain null values");
                }
                this.listeners.add(listener);
            }
        }
    }

    public String getId() {
        return this.request.getId();
    }

    public RequestMessage getRequest() {
        return this.request;
    }

    public synchronized Event setChannelListener(ResponseListener channelListener) {
        if (this.event == null) {
            this.channelListener = channelListener;
        }
        return this.event;
    }

    @Override
    public void run() {
        this.dispatchTimeout(System.currentTimeMillis());
    }

    @Override
    public boolean cancel() {
        return this.dispatchCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseMessage get() throws InterruptedException, ExecutionException, TimeoutException {
        AsyncToken asyncToken = this;
        synchronized (asyncToken) {
            block6: {
                if (this.event == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        if (!this.dispatchCancelled()) break block6;
                        throw e;
                    }
                }
            }
        }
        return ResponseListenerDispatcher.getResponseMessage(this.event);
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.event instanceof CancelledEvent;
    }

    @Override
    public synchronized boolean isDone() {
        return this.event != null;
    }

    public boolean dispatchResult(ResultMessage result) {
        return this.dispatch(new ResultEvent(this.request, result));
    }

    public boolean dispatchFault(FaultMessage fault) {
        return this.dispatch(new FaultEvent(this.request, fault));
    }

    public boolean dispatchFailure(Exception e) {
        return this.dispatch(new FailureEvent(this.request, e));
    }

    public boolean dispatchTimeout(long millis) {
        return this.dispatch(new TimeoutEvent(this.request, millis));
    }

    public boolean dispatchCancelled() {
        return this.dispatch(new CancelledEvent(this.request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatch(Event event) {
        super.cancel();
        AsyncToken asyncToken = this;
        synchronized (asyncToken) {
            if (this.event != null) {
                return false;
            }
            this.event = event;
            if (this.channelListener != null) {
                ResponseListenerDispatcher.dispatch(this.channelListener, event);
            }
            this.notifyAll();
        }
        for (ResponseListener listener : this.listeners) {
            ResponseListenerDispatcher.dispatch(listener, event);
        }
        this.channelListener = null;
        this.listeners.clear();
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof AsyncToken && this.request.getId().equals(((AsyncToken)obj).request.getId());
    }

    public int hashCode() {
        return this.request.getId().hashCode();
    }

    public String toString() {
        return this.getClass().getName() + " {request=" + this.request + "}";
    }
}

