/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.granite.client.messaging.channel.AbstractChannelFactory;
import org.granite.client.messaging.channel.amf.JMFAMFMessagingChannel;
import org.granite.client.messaging.channel.amf.JMFAMFRemotingChannel;
import org.granite.client.messaging.jmf.ClientSharedContext;
import org.granite.client.messaging.jmf.DefaultClientSharedContext;
import org.granite.client.messaging.jmf.ext.ClientEntityCodec;
import org.granite.client.messaging.transport.Transport;
import org.granite.client.platform.Platform;
import org.granite.messaging.jmf.DefaultCodecRegistry;
import org.granite.messaging.jmf.codec.ExtendedObjectCodec;
import org.granite.messaging.reflect.Reflection;
import org.granite.util.ContentType;
import org.granite.util.JMFAMFUtil;

public class JMFChannelFactory
extends AbstractChannelFactory {
    private ClientSharedContext sharedContext = null;
    private List<ExtendedObjectCodec> extendedCodecs = null;
    private List<String> defaultStoredStrings = null;
    private Reflection reflection = null;

    public JMFChannelFactory() {
        super(ContentType.JMF_AMF);
    }

    public JMFChannelFactory(Object context) {
        super(ContentType.JMF_AMF, context);
    }

    public JMFChannelFactory(Object context, ClientSharedContext sharedContext, Transport remotingTransport, Transport messagingTransport) {
        super(ContentType.JMF_AMF, context, remotingTransport, messagingTransport);
        this.sharedContext = sharedContext;
    }

    public ClientSharedContext getSharedContext() {
        return this.sharedContext;
    }

    public void setSharedContext(ClientSharedContext sharedContext) {
        this.sharedContext = sharedContext;
    }

    public List<ExtendedObjectCodec> getExtendedCodecs() {
        return this.extendedCodecs;
    }

    public void setExtendedCodecs(List<ExtendedObjectCodec> extendedCodecs) {
        this.extendedCodecs = extendedCodecs;
    }

    public List<String> getDefaultStoredStrings() {
        return this.defaultStoredStrings;
    }

    public void setDefaultStoredStrings(List<String> defaultStoredStrings) {
        this.defaultStoredStrings = defaultStoredStrings;
    }

    public Reflection getReflection() {
        return this.reflection;
    }

    public void setReflection(Reflection reflection) {
        this.reflection = reflection;
    }

    @Override
    public void start() {
        super.start();
        if (this.sharedContext == null) {
            this.extendedCodecs = this.extendedCodecs != null ? this.extendedCodecs : new ArrayList<ClientEntityCodec>(Arrays.asList(new ClientEntityCodec()));
            this.defaultStoredStrings = this.defaultStoredStrings != null ? this.defaultStoredStrings : new ArrayList<String>(JMFAMFUtil.AMF_DEFAULT_STORED_STRINGS);
            this.reflection = this.reflection != null ? this.reflection : Platform.reflection();
            this.sharedContext = new DefaultClientSharedContext(new DefaultCodecRegistry(this.extendedCodecs), this.defaultStoredStrings, this.reflection, this.aliasRegistry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean stopTransports) {
        try {
            super.stop(stopTransports);
        }
        finally {
            this.sharedContext = null;
            this.extendedCodecs = null;
            this.defaultStoredStrings = null;
            this.reflection = null;
        }
    }

    @Override
    public JMFAMFRemotingChannel newRemotingChannel(String id, URI uri) {
        return this.newRemotingChannel(id, uri, 5);
    }

    @Override
    public JMFAMFRemotingChannel newRemotingChannel(String id, URI uri, int maxConcurrentRequests) {
        return new JMFAMFRemotingChannel(this.getRemotingTransport(), this.getSharedContext(), id, uri, maxConcurrentRequests);
    }

    @Override
    public JMFAMFMessagingChannel newMessagingChannel(String id, URI uri) {
        return new JMFAMFMessagingChannel(this.getMessagingTransport(), this.getSharedContext(), id, uri);
    }
}

