/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel.amf;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.RemotingMessage;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import org.granite.client.messaging.channel.AbstractHTTPChannel;
import org.granite.client.messaging.channel.Credentials;
import org.granite.client.messaging.channel.UsernamePasswordCredentials;
import org.granite.client.messaging.messages.RequestMessage;
import org.granite.client.messaging.messages.push.TopicMessage;
import org.granite.client.messaging.messages.requests.InvocationMessage;
import org.granite.client.messaging.messages.requests.LoginMessage;
import org.granite.client.messaging.messages.requests.PublishMessage;
import org.granite.client.messaging.messages.requests.SubscribeMessage;
import org.granite.client.messaging.messages.requests.UnsubscribeMessage;
import org.granite.client.messaging.messages.responses.AbstractResponseMessage;
import org.granite.client.messaging.messages.responses.FaultMessage;
import org.granite.client.messaging.messages.responses.ResultMessage;
import org.granite.client.messaging.transport.Transport;
import org.granite.messaging.service.security.SecurityServiceException;

public abstract class AbstractAMFChannel
extends AbstractHTTPChannel {
    public AbstractAMFChannel(Transport transport, String id, URI uri, int maxConcurrentRequests) {
        super(transport, id, uri, maxConcurrentRequests);
    }

    protected Message[] convertToAmf(RequestMessage request) throws UnsupportedEncodingException {
        Message[] messages = null;
        switch (request.getType()) {
            case PING: {
                CommandMessage commandMessage = new CommandMessage();
                commandMessage.setOperation(5);
                commandMessage.setMessageId(request.getId());
                commandMessage.setTimestamp(request.getTimestamp());
                commandMessage.setTimeToLive(request.getTimeToLive());
                commandMessage.setHeaders(request.getHeaders());
                messages = new Message[]{commandMessage};
                break;
            }
            case LOGIN: {
                LoginMessage login = (LoginMessage)request;
                CommandMessage commandMessage = new CommandMessage();
                commandMessage.setOperation(8);
                commandMessage.setMessageId(request.getId());
                commandMessage.setTimestamp(request.getTimestamp());
                commandMessage.setTimeToLive(request.getTimeToLive());
                commandMessage.setHeaders(request.getHeaders());
                Credentials credentials = login.getCredentials();
                if (!(credentials instanceof UsernamePasswordCredentials)) {
                    throw new UnsupportedOperationException("Unsupported credentials type: " + credentials);
                }
                commandMessage.setBody(((UsernamePasswordCredentials)credentials).encodeBase64());
                messages = new Message[]{commandMessage};
                break;
            }
            case LOGOUT: {
                CommandMessage commandMessage = new CommandMessage();
                commandMessage.setOperation(9);
                commandMessage.setMessageId(request.getId());
                commandMessage.setTimestamp(request.getTimestamp());
                commandMessage.setTimeToLive(request.getTimeToLive());
                commandMessage.setHeaders(request.getHeaders());
                messages = new Message[]{commandMessage};
                break;
            }
            case PUBLISH: {
                PublishMessage publish = (PublishMessage)request;
                AsyncMessage asyncMessage = new AsyncMessage();
                asyncMessage.setMessageId(publish.getId());
                asyncMessage.setTimestamp(publish.getTimestamp());
                asyncMessage.setTimeToLive(publish.getTimeToLive());
                asyncMessage.setHeaders(publish.getHeaders());
                asyncMessage.setDestination(publish.getDestination());
                asyncMessage.setHeader("DSSubtopic", publish.getTopic());
                asyncMessage.setBody(publish.getBody());
                messages = new Message[]{asyncMessage};
                break;
            }
            case SUBSCRIBE: {
                SubscribeMessage subscribe = (SubscribeMessage)request;
                CommandMessage commandMessage = new CommandMessage();
                commandMessage.setOperation(0);
                commandMessage.setMessageId(subscribe.getId());
                commandMessage.setTimestamp(subscribe.getTimestamp());
                commandMessage.setTimeToLive(subscribe.getTimeToLive());
                commandMessage.setHeaders(subscribe.getHeaders());
                commandMessage.setDestination(subscribe.getDestination());
                commandMessage.setHeader("DSSubtopic", subscribe.getTopic());
                if (subscribe.getSelector() != null) {
                    commandMessage.setHeader("DSSelector", subscribe.getSelector());
                }
                messages = new Message[]{commandMessage};
                break;
            }
            case UNSUBSCRIBE: {
                UnsubscribeMessage unsubscribe = (UnsubscribeMessage)request;
                CommandMessage commandMessage = new CommandMessage();
                commandMessage.setOperation(1);
                commandMessage.setMessageId(unsubscribe.getId());
                commandMessage.setTimestamp(unsubscribe.getTimestamp());
                commandMessage.setTimeToLive(unsubscribe.getTimeToLive());
                commandMessage.setHeaders(unsubscribe.getHeaders());
                commandMessage.setDestination(unsubscribe.getDestination());
                commandMessage.setHeader("DSSubtopic", unsubscribe.getTopic());
                commandMessage.setHeader("DSDstClientId", unsubscribe.getSubscriptionId());
                messages = new Message[]{commandMessage};
                break;
            }
            case INVOCATION: {
                ArrayList<RemotingMessage> remotingMessages = new ArrayList<RemotingMessage>();
                for (InvocationMessage invocation : (InvocationMessage)request) {
                    RemotingMessage remotingMessage = new RemotingMessage();
                    remotingMessage.setDestination(invocation.getServiceId());
                    remotingMessage.setOperation(invocation.getMethod());
                    remotingMessage.setBody(invocation.getParameters() != null ? invocation.getParameters() : new Object[]{});
                    remotingMessage.setMessageId(invocation.getId());
                    remotingMessage.setTimestamp(invocation.getTimestamp());
                    remotingMessage.setTimeToLive(invocation.getTimeToLive());
                    remotingMessage.setHeaders(invocation.getHeaders());
                    remotingMessages.add(remotingMessage);
                }
                messages = remotingMessages.toArray(new Message[remotingMessages.size()]);
                break;
            }
            case DISCONNECT: {
                CommandMessage commandMessage = new CommandMessage();
                commandMessage.setOperation(21);
                commandMessage.setMessageId(request.getId());
                commandMessage.setTimestamp(request.getTimestamp());
                commandMessage.setTimeToLive(request.getTimeToLive());
                commandMessage.setHeaders(request.getHeaders());
                messages = new Message[]{commandMessage};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported message type: " + request);
            }
        }
        for (Message message : messages) {
            message.setClientId(this.getClientId());
            message.setHeader("DSEndpoint", this.getId());
        }
        return messages;
    }

    protected TopicMessage convertFromAmf(AsyncMessage message) {
        return new TopicMessage(message.getMessageId(), (String)message.getClientId(), message.getTimestamp(), message.getTimeToLive(), message.getHeaders(), message.getBody());
    }

    protected AbstractResponseMessage convertFromAmf(AcknowledgeMessage message) {
        if (message instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)message;
            FaultMessage.Code code = FaultMessage.Code.UNKNOWN;
            String flexCode = errorMessage.getFaultCode();
            if ("Server.Call.Failed".equals(flexCode)) {
                code = FaultMessage.Code.SERVER_CALL_FAILED;
            } else if (SecurityServiceException.CODE_ACCESS_DENIED.equals(flexCode)) {
                code = FaultMessage.Code.ACCESS_DENIED;
            } else if (SecurityServiceException.CODE_INVALID_CREDENTIALS.equals(flexCode)) {
                this.authenticated = false;
                code = FaultMessage.Code.INVALID_CREDENTIALS;
            } else if (SecurityServiceException.CODE_AUTHENTICATION_FAILED.equals(flexCode)) {
                this.authenticated = false;
                code = FaultMessage.Code.AUTHENTICATION_FAILED;
            } else if (SecurityServiceException.CODE_NOT_LOGGED_IN.equals(flexCode)) {
                this.authenticated = false;
                code = FaultMessage.Code.NOT_LOGGED_IN;
            } else if (SecurityServiceException.CODE_SESSION_EXPIRED.equals(flexCode)) {
                this.authenticated = false;
                code = FaultMessage.Code.SESSION_EXPIRED;
            } else if ("Validation.Failed".equals(flexCode)) {
                code = FaultMessage.Code.VALIDATION_FAILED;
            } else if ("Persistence.OptimisticLock".equals(flexCode)) {
                code = FaultMessage.Code.OPTIMISTIC_LOCK;
            }
            FaultMessage fault = new FaultMessage(errorMessage.getMessageId(), (String)errorMessage.getClientId(), errorMessage.getTimestamp(), errorMessage.getTimeToLive(), errorMessage.getHeaders(), errorMessage.getCorrelationId(), code, errorMessage.getFaultString(), errorMessage.getFaultDetail(), errorMessage.getRootCause(), errorMessage.getExtendedData());
            if (code == FaultMessage.Code.UNKNOWN) {
                fault.setUnknownCode(flexCode);
            }
            return fault;
        }
        return new ResultMessage(message.getMessageId(), (String)message.getClientId(), message.getTimestamp(), message.getTimeToLive(), message.getHeaders(), message.getCorrelationId(), message.getBody());
    }
}

