/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.codec;

import flex.messaging.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.granite.client.configuration.Configuration;
import org.granite.client.messaging.codec.MessagingCodec;
import org.granite.context.GraniteContext;
import org.granite.context.SimpleGraniteContext;
import org.granite.messaging.amf.io.AMF3Deserializer;
import org.granite.messaging.amf.io.AMF3Serializer;
import org.granite.util.ContentType;

public class AMF3MessagingCodec
implements MessagingCodec<Message[]> {
    private final Configuration config;

    public AMF3MessagingCodec(Configuration config) {
        this.config = config;
    }

    @Override
    public MessagingCodec.ClientType getClientType() {
        return this.config.getClientType();
    }

    @Override
    public String getContentType() {
        return ContentType.AMF.mimeType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Message[] messages, OutputStream output) throws IOException {
        SimpleGraniteContext.createThreadInstance(this.config.getGraniteConfig(), this.config.getServicesConfig(), new HashMap<String, Object>(0), this.getClientType().toString());
        try {
            AMF3Serializer serializer = new AMF3Serializer(output);
            serializer.writeObject(messages);
            serializer.close();
        }
        finally {
            GraniteContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message[] decode(InputStream input) throws IOException {
        SimpleGraniteContext.createThreadInstance(this.config.getGraniteConfig(), this.config.getServicesConfig(), new HashMap<String, Object>(0), this.getClientType().toString());
        try {
            AMF3Deserializer deserializer = new AMF3Deserializer(input);
            Object[] objects = (Object[])deserializer.readObject();
            deserializer.close();
            if (objects != null) {
                Message[] messages = new Message[objects.length];
                System.arraycopy(objects, 0, messages, 0, objects.length);
                for (Message message : messages) {
                    if (message == null || !Boolean.TRUE.equals(message.getHeader("GDS_BYTEARRAY_BODY"))) continue;
                    byte[] body = (byte[])message.getBody();
                    deserializer = new AMF3Deserializer(new ByteArrayInputStream(body));
                    message.setBody(deserializer.readObject());
                    deserializer.close();
                }
                Message[] messageArray = messages;
                return messageArray;
            }
            Message[] messageArray = new Message[]{};
            return messageArray;
        }
        finally {
            GraniteContext.release();
        }
    }
}

