/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.messages.responses;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.granite.client.messaging.messages.AbstractMessage;
import org.granite.client.messaging.messages.ResponseMessage;

public abstract class AbstractResponseMessage
extends AbstractMessage
implements ResponseMessage {
    private String correlationId;
    private ResponseMessage next;

    public AbstractResponseMessage() {
    }

    public AbstractResponseMessage(String clientId, String correlationId) {
        super(clientId);
        this.correlationId = correlationId;
    }

    public AbstractResponseMessage(String id, String clientId, long timestamp, long timeToLive, Map<String, Object> headers, String correlationId) {
        super(id, clientId, timestamp, timeToLive, headers);
        this.correlationId = correlationId;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    @Override
    public void setNext(ResponseMessage next) {
        for (ResponseMessage n = next; n != null; n = (ResponseMessage)n.getNext()) {
            if (n != this) continue;
            throw new RuntimeException("Circular chaining to this: " + next);
        }
        this.next = next;
    }

    @Override
    public ResponseMessage getNext() {
        return this.next;
    }

    @Override
    public Iterator<ResponseMessage> iterator() {
        final AbstractResponseMessage first = this;
        return new Iterator<ResponseMessage>(){
            private ResponseMessage current;
            {
                this.current = first;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public ResponseMessage next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                ResponseMessage c = this.current;
                this.current = (ResponseMessage)this.current.getNext();
                return c;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.correlationId = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.correlationId != null) {
            out.writeUTF(this.correlationId);
        } else {
            out.writeObject(null);
        }
    }

    @Override
    protected void copy(AbstractMessage message) {
        this.copy((AbstractResponseMessage)message, this.correlationId);
    }

    protected void copy(AbstractResponseMessage message, String correlationId) {
        super.copy(message);
        message.correlationId = correlationId;
    }

    @Override
    public ResponseMessage copy(String correlationId) {
        AbstractResponseMessage message = (AbstractResponseMessage)this.copy();
        message.correlationId = correlationId;
        return message;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return super.toString(sb).append("\n    correlationId=").append(this.correlationId);
    }
}

