/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.messages.responses;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.granite.client.messaging.messages.Message;
import org.granite.client.messaging.messages.responses.AbstractResponseMessage;

public final class FaultMessage
extends AbstractResponseMessage {
    private Code code;
    private String description;
    private String details;
    private Object cause;
    private Map<String, Object> extended;
    private String unknownCode;

    public FaultMessage() {
    }

    public FaultMessage(String clientId, String correlationId, Code code, String description, String details, Object cause, Map<String, Object> extended) {
        super(clientId, correlationId);
        this.code = code;
        this.description = description;
        this.details = details;
        this.cause = cause;
        this.extended = extended;
    }

    public FaultMessage(String id, String clientId, long timestamp, long timeToLive, Map<String, Object> headers, String correlationId, Code code, String description, String details, Object cause, Map<String, Object> extended) {
        super(id, clientId, timestamp, timeToLive, headers, correlationId);
        this.code = code;
        this.description = description;
        this.details = details;
        this.cause = cause;
        this.extended = extended;
    }

    @Override
    public Message.Type getType() {
        return Message.Type.FAULT;
    }

    public boolean isSecurityFault() {
        switch (this.code) {
            case UNKNOWN: {
                return this.unknownCode != null && this.unknownCode.startsWith("Server.Security.");
            }
            case INVALID_CREDENTIALS: 
            case AUTHENTICATION_FAILED: 
            case NOT_LOGGED_IN: 
            case SESSION_EXPIRED: 
            case ACCESS_DENIED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getData() {
        return this.toString();
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public Object getCause() {
        return this.cause;
    }

    public void setCause(Object cause) {
        this.cause = cause;
    }

    public Map<String, Object> getExtended() {
        return this.extended;
    }

    public void setExtended(Map<String, Object> extended) {
        this.extended = extended;
    }

    public String getUnknownCode() {
        return this.unknownCode;
    }

    public void setUnknownCode(String unknownCode) {
        this.unknownCode = unknownCode;
    }

    @Override
    public FaultMessage copy() {
        FaultMessage message = new FaultMessage();
        super.copy(message);
        message.code = this.code;
        message.description = this.description;
        message.details = this.details;
        message.cause = this.cause;
        message.extended = this.extended;
        return message;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.code = (Code)((Object)in.readObject());
        this.description = in.readUTF();
        this.details = in.readUTF();
        this.cause = in.readObject();
        this.extended = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject((Object)this.code);
        if (this.description != null) {
            out.writeUTF(this.description);
        } else {
            out.writeObject(null);
        }
        if (this.details != null) {
            out.writeUTF(this.details);
        } else {
            out.writeObject(null);
        }
        out.writeObject(this.cause);
        out.writeObject(this.extended);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return super.toString(sb).append("\n    code=").append((Object)this.code).append("\n    description=").append(this.description).append("\n    details=").append(this.details).append("\n    cause=").append(this.cause).append("\n    extended=").append(this.extended);
    }

    public static enum Code {
        UNKNOWN,
        CLIENT_CALL_FAILED,
        CLIENT_CALL_TIMED_OUT,
        CLIENT_CALL_CANCELLED,
        SERVER_CALL_FAILED,
        INVALID_CREDENTIALS,
        AUTHENTICATION_FAILED,
        NOT_LOGGED_IN,
        SESSION_EXPIRED,
        ACCESS_DENIED,
        VALIDATION_FAILED,
        OPTIMISTIC_LOCK;

    }
}

