/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.transport;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.client.messaging.codec.MessagingCodec;
import org.granite.client.messaging.transport.TransportMessage;

public class DefaultTransportMessage<M>
implements TransportMessage {
    private final String id;
    private final boolean connect;
    private final String clientId;
    private final String sessionId;
    private final M message;
    private final MessagingCodec<M> codec;

    public DefaultTransportMessage(String id, boolean connect, String clientId, String sessionId, M message, MessagingCodec<M> codec) {
        this.id = id;
        this.connect = connect;
        this.clientId = clientId;
        this.sessionId = sessionId;
        this.message = message;
        this.codec = codec;
    }

    @Override
    public MessagingCodec.ClientType getClientType() {
        return this.codec.getClientType();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isConnect() {
        return this.connect;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getContentType() {
        return this.codec.getContentType();
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        this.codec.encode(this.message, os);
    }
}

