/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.transport.jetty;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketClient;
import org.eclipse.jetty.websocket.WebSocketClientFactory;
import org.granite.client.messaging.channel.Channel;
import org.granite.client.messaging.transport.AbstractTransport;
import org.granite.client.messaging.transport.TransportException;
import org.granite.client.messaging.transport.TransportFuture;
import org.granite.client.messaging.transport.TransportMessage;
import org.granite.client.messaging.transport.WebSocketTransport;
import org.granite.logging.Logger;
import org.granite.util.PublicByteArrayOutputStream;

public class JettyWebSocketTransport
extends AbstractTransport<Object>
implements WebSocketTransport {
    private static final Logger log = Logger.getLogger(JettyWebSocketTransport.class);
    private static final int CLOSE_NORMAL = 1000;
    private static final int CLOSE_SHUTDOWN = 1001;
    private WebSocketClientFactory webSocketClientFactory = null;
    private Future<WebSocket.Connection> connectionFuture = null;
    private boolean connected = false;
    private int maxIdleTime = 3000000;
    private int reconnectMaxAttempts = 5;
    private int reconnectIntervalMillis = 60000;
    private int reconnectAttempts = 0;
    private TransportMessage connectMessage = null;

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public synchronized boolean start() {
        if (this.isStarted()) {
            return true;
        }
        log.info("Starting Jetty WebSocketClient transport...", new Object[0]);
        try {
            this.webSocketClientFactory = new WebSocketClientFactory();
            this.webSocketClientFactory.setBufferSize(4096);
            this.webSocketClientFactory.start();
            long timeout = System.currentTimeMillis() + 10000L;
            while (!this.webSocketClientFactory.isStarted()) {
                if (System.currentTimeMillis() > timeout) {
                    throw new TimeoutException("Jetty WebSocketFactory start process too long");
                }
                Thread.sleep(100L);
            }
            log.info("Jetty WebSocketClient transport started.", new Object[0]);
            return true;
        }
        catch (Exception e) {
            this.webSocketClientFactory = null;
            this.getStatusHandler().handleException(new TransportException("Could not start Jetty WebSocketFactory", e));
            log.error(e, "Jetty WebSocketClient transport failed to start.", new Object[0]);
            return false;
        }
    }

    @Override
    public synchronized boolean isStarted() {
        return this.webSocketClientFactory != null && this.webSocketClientFactory.isStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransportFuture send(Channel channel, TransportMessage message) {
        Channel channel2 = channel;
        synchronized (channel2) {
            TransportData transportData = (TransportData)channel.getTransportData();
            if (transportData == null) {
                transportData = new TransportData();
                channel.setTransportData(transportData);
            }
            if (message != null) {
                if (message.isConnect()) {
                    this.connectMessage = message;
                } else {
                    transportData.pendingMessages.addLast(message);
                }
            }
            if (transportData.connection == null) {
                this.connect(channel, message);
                return null;
            }
            while (!transportData.pendingMessages.isEmpty()) {
                TransportMessage pendingMessage = (TransportMessage)transportData.pendingMessages.removeFirst();
                try {
                    PublicByteArrayOutputStream os = new PublicByteArrayOutputStream(256);
                    pendingMessage.encode(os);
                    byte[] data = os.getBytes();
                    transportData.connection.sendMessage(data, 0, os.size());
                }
                catch (IOException e) {
                    transportData.pendingMessages.addFirst(pendingMessage);
                    break;
                }
            }
        }
        return null;
    }

    @Override
    public void poll(Channel channel, TransportMessage message) {
        this.send(channel, message);
    }

    public Future<WebSocket.Connection> connect(final Channel channel, final TransportMessage transportMessage) {
        if (this.connectionFuture != null) {
            return this.connectionFuture;
        }
        this.connected = true;
        URI uri = channel.getUri();
        try {
            WebSocketClient webSocketClient = this.webSocketClientFactory.newWebSocketClient();
            webSocketClient.setMaxIdleTime(this.maxIdleTime);
            webSocketClient.setMaxTextMessageSize(1024);
            webSocketClient.setProtocol("org.granite.gravity");
            if (transportMessage.getSessionId() != null) {
                webSocketClient.getCookies().put("JSESSIONID", transportMessage.getSessionId());
            }
            String u = uri.toString();
            u = u + "?connectId=" + transportMessage.getId() + "&GDSClientType=" + (Object)((Object)transportMessage.getClientType());
            if (transportMessage.getClientId() != null) {
                u = u + "&GDSClientId=" + transportMessage.getClientId();
            } else if (channel.getClientId() != null) {
                u = u + "&GDSClientId=" + channel.getClientId();
            }
            this.connectionFuture = webSocketClient.open(new URI(u), (WebSocket)new WebSocket.OnBinaryMessage(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onOpen(WebSocket.Connection connection) {
                    Channel channel2 = channel;
                    synchronized (channel2) {
                        JettyWebSocketTransport.this.connectionFuture = null;
                        JettyWebSocketTransport.this.reconnectAttempts = 0;
                        ((TransportData)channel.getTransportData()).connection = connection;
                        JettyWebSocketTransport.this.send(channel, null);
                    }
                }

                public void onMessage(byte[] data, int offset, int length) {
                    channel.onMessage(new ByteArrayInputStream(data, offset, length));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClose(int closeCode, String message) {
                    boolean waitBeforeReconnect = closeCode != 1000 || !message.startsWith("Idle");
                    Channel channel2 = channel;
                    synchronized (channel2) {
                        ((TransportData)channel.getTransportData()).connection = null;
                        JettyWebSocketTransport.this.connectionFuture = null;
                        if (!JettyWebSocketTransport.this.isStarted()) {
                            JettyWebSocketTransport.this.connected = false;
                        }
                        if (closeCode == 1001) {
                            JettyWebSocketTransport.this.connected = false;
                            return;
                        }
                        if (channel.getClientId() == null) {
                            JettyWebSocketTransport.this.getStatusHandler().handleException(new TransportException("Transport could not connect code: " + closeCode + " " + message));
                            return;
                        }
                        if (JettyWebSocketTransport.this.connected) {
                            if (JettyWebSocketTransport.this.reconnectAttempts >= JettyWebSocketTransport.this.reconnectMaxAttempts) {
                                JettyWebSocketTransport.this.connected = false;
                                if (JettyWebSocketTransport.this.isStarted()) {
                                    JettyWebSocketTransport.this.stop();
                                }
                                channel.onError(transportMessage, new RuntimeException(message + " (code=" + closeCode + ")"));
                                JettyWebSocketTransport.this.getStatusHandler().handleException(new TransportException("Transport disconnected"));
                                return;
                            }
                            if (waitBeforeReconnect) {
                                try {
                                    waitBeforeReconnect = false;
                                    Thread.sleep(JettyWebSocketTransport.this.reconnectIntervalMillis);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                            JettyWebSocketTransport.this.reconnectAttempts++;
                            log.info("Connection lost (code %d, msg %s), reconnect channel (retry #%d)", closeCode, message, JettyWebSocketTransport.this.reconnectAttempts);
                            JettyWebSocketTransport.this.connect(channel, JettyWebSocketTransport.this.connectMessage);
                        }
                    }
                }
            });
            return this.connectionFuture;
        }
        catch (Exception e) {
            this.getStatusHandler().handleException(new TransportException("Could not connect to uri " + channel.getUri(), e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.webSocketClientFactory == null) {
            return;
        }
        log.info("Stopping Jetty WebSocketClient transport...", new Object[0]);
        super.stop();
        try {
            this.webSocketClientFactory.stop();
        }
        catch (Exception e) {
            this.getStatusHandler().handleException(new TransportException("Could not stop Jetty WebSocketFactory", e));
            log.error(e, "Jetty WebSocketClient failed to stop properly.", new Object[0]);
        }
        finally {
            this.webSocketClientFactory = null;
        }
        log.info("Jetty WebSocketClient transport stopped.", new Object[0]);
    }

    private static class TransportData {
        private final LinkedList<TransportMessage> pendingMessages = new LinkedList();
        private WebSocket.Connection connection = null;

        private TransportData() {
        }
    }
}

